/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.values;

import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.KeyValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Entry
implements KeyValueModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String key;
    private Comment comment;
    private List<String> values;
    private char separator = (char)61;

    public Entry(String key, String ... values) {
        this.key = key;
        this.comment = new Comment();
        this.values = new ArrayList<String>();
        for (String v : values) {
            this.values.add(v);
        }
    }

    public Entry(String key, Comment comment, String ... values) {
        this.key = key;
        this.comment = comment;
        this.values = new ArrayList<String>();
        for (String v : values) {
            this.values.add(v);
        }
    }

    public Entry(String key, char separator, Comment comment, List<String> values) {
        this.key = key;
        this.comment = comment;
        this.values = values;
        this.separator = separator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public Comment getComments() {
        return this.comment;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue() {
        StringBuffer buf = new StringBuffer();
        for (String v : this.values) {
            buf.append(v);
        }
        return buf.toString();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    public boolean containsUnicodeEscape() {
        if (this.key.contains("\\u")) {
            return true;
        }
        for (String val : this.values) {
            if (!val.contains("\\u")) continue;
            return true;
        }
        return this.comment != null && this.comment.containsUnicodeEscape();
    }
}

