/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.ref;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.impl.PropertiesImpl;
import asia.redact.bracket.properties.line.LineScanner;
import asia.redact.bracket.properties.ref.PropertiesReference;
import asia.redact.bracket.properties.ref.ReferenceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class LoadList {
    final List<PropertiesReference> list = new ArrayList<PropertiesReference>();
    final Properties props;

    public LoadList() {
        this.props = new PropertiesImpl(false).init();
    }

    public LoadList(Properties props) {
        this.props = props;
    }

    public LoadList addReference(File file) {
        try {
            this.list.add(new PropertiesReference(ReferenceType.EXTERNAL, file.getCanonicalPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public LoadList addReference(ReferenceType type, String data) {
        this.list.add(new PropertiesReference(type, data));
        return this;
    }

    public LoadList addReference(PropertiesReference ref) {
        this.list.add(ref);
        return this;
    }

    public LoadList load() {
        block6: for (PropertiesReference ref : this.list) {
            switch (ref.type) {
                case CLASSLOADED: {
                    this.loadFromClasspath(ref);
                    continue block6;
                }
                case DIRECT: {
                    this.loadFromDirect(ref);
                    continue block6;
                }
                case EXTERNAL: {
                    this.loadFromExternal(ref);
                    continue block6;
                }
                case COMMANDLINE_OVERRIDE: {
                    this.loadFromSystemProps(ref.data);
                    continue block6;
                }
            }
            throw new RuntimeException("Unknown type: " + ref);
        }
        return this;
    }

    private void loadFromSystemProps(String key) {
        String val = System.getProperty(key);
        if (val != null) {
            this.props.put(key, val);
        }
    }

    private void loadFromClasspath(PropertiesReference ref) {
        InputStream in = this.getClass().getResourceAsStream(ref.data);
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(ref.data)) == null) {
            throw new RuntimeException("path " + ref.data + " was not found as a ResourceStream");
        }
        try (InputStreamReader reader = new InputStreamReader(in, ref.charset);
             BufferedReader breader = new BufferedReader(reader);
             LineScanner scanner = new LineScanner(breader);){
            PropertiesParser parser = new PropertiesParser(scanner);
            this.props.merge(parser.parse().getProperties());
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private void loadFromDirect(PropertiesReference ref) {
        try (StringReader reader = new StringReader(ref.data);
             LineScanner scanner = new LineScanner(reader);){
            PropertiesParser parser = new PropertiesParser(scanner);
            this.props.merge(parser.parse().getProperties());
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private void loadFromExternal(PropertiesReference ref) {
        File file = new File(ref.data);
        if (file.isDirectory()) {
            File[] mylist;
            for (File f : mylist = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(".properties");
                }
            })) {
                try (FileInputStream in = new FileInputStream(f);
                     InputStreamReader reader = new InputStreamReader((InputStream)in, ref.charset);
                     BufferedReader breader = new BufferedReader(reader);
                     LineScanner scanner = new LineScanner(breader);){
                    PropertiesParser parser = new PropertiesParser(scanner);
                    this.props.merge(parser.parse().getProperties());
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        } else {
            try (FileInputStream in = new FileInputStream(file);
                 InputStreamReader reader = new InputStreamReader((InputStream)in, ref.charset);
                 BufferedReader breader = new BufferedReader(reader);
                 LineScanner scanner = new LineScanner(breader);){
                PropertiesParser parser = new PropertiesParser(scanner);
                this.props.merge(parser.parse().getProperties());
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public List<PropertiesReference> getList() {
        return this.list;
    }

    public Properties getProps() {
        return this.props;
    }
}

