/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.io;

import asia.redact.bracket.properties.io.OutputFormat;
import asia.redact.bracket.properties.values.Comment;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLOutputFormat
implements OutputFormat {
    private static final String top = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";
    private static final String doctype = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">";
    private static final Pattern specialChars = Pattern.compile(">|<|'|\"|&");
    private final String comment;

    public XMLOutputFormat(String comment) {
        this.comment = comment;
    }

    @Override
    public String formatContentType() {
        StringBuilder b = new StringBuilder();
        b.append(top);
        b.append("\n");
        b.append(doctype);
        b.append("\n");
        return b.toString();
    }

    @Override
    public String formatHeader() {
        if (this.comment == null) {
            return "<properties>\n<comment/>\n";
        }
        StringBuffer b = new StringBuffer();
        b.append("<properties>\n");
        b.append("<comment>\n");
        if (this.hasXMLSpecialChar(this.comment)) {
            b.append("<![CDATA[");
            b.append(this.comment);
            b.append("]]>");
        } else {
            b.append(this.comment);
        }
        b.append("<comment/>\n");
        return b.toString();
    }

    @Override
    public String format(String key, char separator, List<String> values, Comment comments) {
        StringBuilder b = new StringBuilder();
        b.append("<entry key=\"");
        b.append(key);
        b.append("\">");
        values.forEach(item -> {
            if (this.hasXMLSpecialChar((String)item)) {
                b.append("<![CDATA[");
                b.append((String)item);
                b.append("]]>");
            } else {
                b.append((String)item);
            }
        });
        b.append("</entry>");
        b.append("\n");
        return b.toString();
    }

    @Override
    public String formatFooter() {
        return "</properties>\n";
    }

    private boolean hasXMLSpecialChar(String item) {
        Matcher m = specialChars.matcher(item);
        return m.find();
    }
}

