/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.io;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.io.AsciiOutputFormat;
import asia.redact.bracket.properties.io.OutputFormat;
import asia.redact.bracket.properties.io.PlainOutputFormat;
import asia.redact.bracket.properties.io.XMLOutputFormat;
import asia.redact.bracket.properties.json.JsonObject;
import asia.redact.bracket.properties.json.WriterConfig;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;

public class OutputAdapter {
    final Properties props;

    public OutputAdapter(Properties properties) {
        this.props = properties;
    }

    public void writeTo(OutputStream out, OutputFormat format, Charset charset) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, charset);){
            this.writeTo(writer, format);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeTo(File file, OutputFormat format, Charset charset) {
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);){
            this.writeTo(writer, format);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeTo(File file, Charset charset) {
        if (charset.name().equals("US-ASCII") || charset.name().equals("ISO-8859-1")) {
            this.writeAsciiTo(file, new PlainOutputFormat());
            return;
        }
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);){
            this.writeTo(writer, new PlainOutputFormat());
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeAsciiTo(File file, OutputFormat format) {
        this.writeTo(file, format, Charset.forName("ISO-8859-1"));
    }

    public void writeAsciiTo(File file) {
        this.writeTo(file, (OutputFormat)new AsciiOutputFormat(), Charset.forName("ISO-8859-1"));
    }

    public void writeAsciiTo(Writer writer) {
        try {
            this.writeTo(writer, new AsciiOutputFormat());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeTo(Writer writer, OutputFormat format) throws IOException {
        Set<Map.Entry<String, ValueModel>> set = this.props.asMap().entrySet();
        writer.append(format.formatContentType());
        writer.append(format.formatHeader());
        for (Map.Entry<String, ValueModel> e : set) {
            String key = e.getKey();
            ValueModel model = e.getValue();
            writer.append(format.format(key, model.getSeparator(), model.getValues(), model.getComments()));
        }
        writer.append(format.formatFooter());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, new PlainOutputFormat());
    }

    public static final String toString(Properties props) {
        OutputAdapter out = new OutputAdapter(props);
        StringWriter writer = new StringWriter();
        try {
            out.writeTo(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String toXML(Properties props) {
        StringWriter writer = new StringWriter();
        try {
            new OutputAdapter(props).writeTo(writer, new XMLOutputFormat(null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static final String toJSON(Properties props) {
        return OutputAdapter.toJSON(props, WriterConfig.PRETTY_PRINT);
    }

    public static final String toJSON(Properties props, WriterConfig config) {
        JsonObject contents = new JsonObject();
        props.forEach((k, v) -> contents.add((String)k, v.getValue()));
        return contents.toString(config);
    }
}

