/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.impl;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.impl.PropertiesImpl;
import asia.redact.bracket.properties.io.AsciiToNativeFilter;
import asia.redact.bracket.properties.io.NativeToAsciiFilter;
import asia.redact.bracket.properties.values.BasicValueModel;
import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SortedPropertiesImpl
extends PropertiesImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Comparator<CharSequence> comparator;

    public SortedPropertiesImpl(boolean concurrent, Comparator<CharSequence> comparator) {
        super(concurrent);
        this.comparator = comparator;
    }

    @Override
    public Properties init() {
        this.map = this.comparator == null ? (this.concurrent ? Collections.synchronizedMap(new TreeMap()) : new TreeMap()) : (this.concurrent ? Collections.synchronizedMap(new TreeMap(this.comparator)) : new TreeMap(this.comparator));
        return this;
    }

    @Override
    public Properties asciiToNative() {
        Properties impl = new SortedPropertiesImpl(this.concurrent, this.comparator).init();
        for (Map.Entry entry : this.map.entrySet()) {
            ValueModel model = (ValueModel)entry.getValue();
            List<String> values = model.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            if (values.size() > 0) {
                values.forEach((? super T item) -> newValues.add(new AsciiToNativeFilter((String)item).read()));
            }
            String comments = model.getComments().comments;
            StringBuffer buf = new StringBuffer();
            if (comments != null && comments.length() > 4) {
                buf.append(new AsciiToNativeFilter(comments).read());
            }
            Comment newComments = new Comment(buf.toString());
            impl.put((String)entry.getKey(), new BasicValueModel(newComments, model.getSeparator(), newValues));
        }
        return impl;
    }

    @Override
    public Properties nativeToAscii() {
        Properties impl = new SortedPropertiesImpl(this.concurrent, this.comparator).init();
        for (Map.Entry entry : this.map.entrySet()) {
            ValueModel model = (ValueModel)entry.getValue();
            List<String> values = model.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            if (values.size() > 0) {
                values.forEach((? super T item) -> newValues.add(new NativeToAsciiFilter().write((String)item).getResult()));
            }
            String comments = model.getComments().comments;
            StringBuffer buf = new StringBuffer();
            if (comments != null && comments.length() > 4) {
                buf.append(new NativeToAsciiFilter().write(comments).getResult());
            }
            Comment newComments = new Comment(buf.toString());
            impl.put((String)entry.getKey(), new BasicValueModel(newComments, model.getSeparator(), newValues));
        }
        return impl;
    }
}

