/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.impl;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.impl.AbstractMapDerivedPropertiesBase;
import asia.redact.bracket.properties.io.AsciiToNativeFilter;
import asia.redact.bracket.properties.io.NativeToAsciiFilter;
import asia.redact.bracket.properties.io.OutputAdapter;
import asia.redact.bracket.properties.values.BasicValueModel;
import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.Entry;
import asia.redact.bracket.properties.values.KeyValueModel;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class PropertiesImpl
extends AbstractMapDerivedPropertiesBase
implements Properties,
Serializable {
    private static final long serialVersionUID = 1L;

    public PropertiesImpl() {
        super(false);
    }

    public PropertiesImpl(boolean concurrent) {
        super(concurrent);
    }

    @Override
    public Properties init() {
        this.map = this.concurrent ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
        return this;
    }

    @Override
    public String get(String key) {
        ValueModel val = (ValueModel)this.map.get(key);
        if (val == null) {
            throw new RuntimeException("Missing value " + key + ". Normally you would test for the existence of keys by using containsKey(key) prior to using get() if there is doubt");
        }
        return val.getValue();
    }

    @Override
    public String get(String key, String defaultVal) {
        if (!this.map.containsKey(key)) {
            return defaultVal;
        }
        return this.get(key);
    }

    @Override
    public List<String> getValues(String key) {
        return ((ValueModel)this.map.get(key)).getValues();
    }

    @Override
    public Comment getComments(String key) {
        return ((ValueModel)this.map.get(key)).getComments();
    }

    @Override
    public char getSeparator(String key) {
        return ((ValueModel)this.map.get(key)).getSeparator();
    }

    @Override
    public void forEach(BiConsumer<String, ValueModel> action) {
        this.map.forEach(action);
    }

    @Override
    public void put(String key, Comment comment, String ... values) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new BasicValueModel(comment, values));
        } else {
            ValueModel val = (ValueModel)this.map.get(key);
            if (val instanceof BasicValueModel) {
                ((BasicValueModel)val).addComment(comment.comments);
            }
            val.getValues().clear();
            for (String s : values) {
                val.getValues().add(s);
            }
        }
    }

    @Override
    public void put(String key, char separator, Comment comment, String ... values) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new BasicValueModel(comment, separator, values));
        } else {
            ValueModel val = (ValueModel)this.map.get(key);
            if (val instanceof BasicValueModel) {
                ((BasicValueModel)val).addComment(comment.comments);
                ((BasicValueModel)val).setSeparator(separator);
            }
            val.getValues().clear();
            for (String s : values) {
                val.getValues().add(s);
            }
        }
    }

    @Override
    public void put(KeyValueModel model) {
        this.put(model.getKey(), model);
    }

    @Override
    public void put(String key, ValueModel model) {
        this.map.put(key, model);
    }

    @Override
    public boolean hasNonEmptyValue(String key) {
        String val = this.get(key);
        return val != null && !val.trim().equals("");
    }

    @Override
    public void deleteKey(String key) {
        this.map.remove(key);
    }

    @Override
    public Properties merge(Properties props) {
        Map<String, ValueModel> his = props.asMap();
        this.map.putAll(his);
        return this;
    }

    @Override
    public Properties slice(String root) {
        PropertiesImpl impl = new PropertiesImpl(false);
        for (String key : this.map.keySet()) {
            if (!key.startsWith(root)) continue;
            ValueModel value = (ValueModel)this.map.get(key);
            impl.put(key, value);
        }
        return impl;
    }

    @Override
    public Map<String, ValueModel> asMap() {
        return this.map;
    }

    @Override
    public Map<String, String> asFlattenedMap() {
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        for (String key : this.map.keySet()) {
            String value = ((ValueModel)this.map.get(key)).getValue();
            out.put(key, value);
        }
        return out;
    }

    @Override
    public List<KeyValueModel> asList() {
        ArrayList<KeyValueModel> list = new ArrayList<KeyValueModel>();
        for (Map.Entry e : this.map.entrySet()) {
            list.add(new Entry((String)e.getKey(), ((ValueModel)e.getValue()).getSeparator(), ((ValueModel)e.getValue()).getComments(), ((ValueModel)e.getValue()).getValues()));
        }
        return list;
    }

    @Override
    public java.util.Properties asLegacy() {
        java.util.Properties legacy = new java.util.Properties();
        for (String key : this.map.keySet()) {
            String value = this.get(key);
            legacy.put(key, value);
        }
        return legacy;
    }

    @Override
    public String toXML() {
        return OutputAdapter.toXML(this);
    }

    @Override
    public String toJSON() {
        return OutputAdapter.toJSON(this);
    }

    @Override
    public String toYAML() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueModel getValueModel(String key) {
        ValueModel model = (ValueModel)this.map.get(key);
        return new Entry(key, model.getSeparator(), model.getComments(), model.getValues());
    }

    @Override
    public void put(String key, String ... values) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new BasicValueModel(values));
        } else {
            ValueModel val = (ValueModel)this.map.get(key);
            val.getValues().clear();
            for (String s : values) {
                val.getValues().add(s);
            }
        }
    }

    @Override
    public Properties asciiToNative() {
        Properties impl = new PropertiesImpl(this.concurrent).init();
        for (Map.Entry entry : this.map.entrySet()) {
            ValueModel model = (ValueModel)entry.getValue();
            List<String> values = model.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            if (values.size() > 0) {
                values.forEach((? super T item) -> {
                    String newVal = new AsciiToNativeFilter((String)item).read();
                    newValues.add(newVal);
                });
            }
            String comments = model.getComments().comments;
            StringBuffer buf = new StringBuffer();
            if (comments != null && comments.length() > 4) {
                buf.append(new AsciiToNativeFilter(comments).read());
            }
            Comment newComments = new Comment(buf.toString());
            impl.put((String)entry.getKey(), new BasicValueModel(newComments, model.getSeparator(), newValues));
        }
        return impl;
    }

    @Override
    public Properties nativeToAscii() {
        Properties impl = new PropertiesImpl(this.concurrent).init();
        for (Map.Entry entry : this.map.entrySet()) {
            ValueModel model = (ValueModel)entry.getValue();
            List<String> values = model.getValues();
            ArrayList<String> newValues = new ArrayList<String>();
            if (values.size() > 0) {
                values.forEach((? super T item) -> newValues.add(new NativeToAsciiFilter().write((String)item).getResult()));
            }
            String comments = model.getComments().comments;
            StringBuffer buf = new StringBuffer();
            if (comments != null && comments.length() > 4) {
                buf.append(new NativeToAsciiFilter().write(comments).getResult());
            }
            Comment newComments = new Comment(buf.toString());
            impl.put((String)entry.getKey(), new BasicValueModel(newComments, model.getSeparator(), newValues));
        }
        return impl;
    }

    @Override
    public List<String> getMatchingKeys(String regex) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.keySet()) {
            if (!key.matches(regex)) continue;
            ValueModel value = (ValueModel)this.map.get(key);
            list.add(value.getValue());
        }
        return list;
    }

    @Override
    public boolean hasKeyLike(String partial) {
        for (String key : this.keySet()) {
            if (!key.startsWith(partial)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUnicodeEscape() {
        for (Map.Entry entry : this.map.entrySet()) {
            if (((String)entry.getKey()).contains("\\u")) {
                return true;
            }
            if (!((ValueModel)entry.getValue()).containsUnicodeEscape()) continue;
            return true;
        }
        return false;
    }
}

