/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.impl;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.impl.ListBackedPropertiesImpl;
import asia.redact.bracket.properties.io.AsciiToNativeFilter;
import asia.redact.bracket.properties.io.NativeToAsciiFilter;
import asia.redact.bracket.properties.io.OutputAdapter;
import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.Entry;
import asia.redact.bracket.properties.values.KeyValueModel;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class PojoPropertiesImpl
implements Properties,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Entry[] entries;

    public abstract Properties init();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int find(String key) {
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!this.entries[i].getKey().equals(key)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    @Override
    public String get(String key) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key);
        }
        return this.entries[i].getValue();
    }

    @Override
    public String get(String key, String defaultVal) {
        int i = this.find(key);
        if (i == -1) {
            return defaultVal;
        }
        return this.entries[i].getValue();
    }

    @Override
    public List<String> getValues(String key) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key);
        }
        return this.entries[i].getValues();
    }

    @Override
    public Comment getComments(String key) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key);
        }
        return this.entries[i].getComments();
    }

    @Override
    public char getSeparator(String key) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key);
        }
        return this.entries[i].getSeparator();
    }

    @Override
    public ValueModel getValueModel(String key) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key);
        }
        return this.entries[i];
    }

    @Override
    public void put(String key, String ... values) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key + ". Cannot add keys in this implementation.");
        }
        Entry e = this.entries[i];
        ArrayList<String> list = new ArrayList<String>();
        for (String s : values) {
            list.add(s);
        }
        e.setValues(list);
    }

    @Override
    public void put(String key, Comment comment, String ... values) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key + ". Cannot add keys in this implementation.");
        }
        Entry e = this.entries[i];
        ArrayList<String> list = new ArrayList<String>();
        for (String s : values) {
            list.add(s);
        }
        e.setValues(list);
        e.setComment(comment);
    }

    @Override
    public void put(String key, char separator, Comment comment, String ... values) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key + ". Cannot add keys in this implementation.");
        }
        Entry e = this.entries[i];
        ArrayList<String> list = new ArrayList<String>();
        for (String s : values) {
            list.add(s);
        }
        e.setValues(list);
        e.setComment(comment);
        e.setSeparator(separator);
    }

    @Override
    public void put(KeyValueModel model) {
        int i = this.find(model.getKey());
        if (i == -1) {
            throw new RuntimeException("key not found: " + model.getKey() + ". Cannot add keys in this implementation.");
        }
        Entry e = this.entries[i];
        ArrayList<String> list = new ArrayList<String>();
        for (String s : model.getValues()) {
            list.add(s);
        }
        e.setValues(list);
        e.setComment(model.getComments());
        e.setSeparator(model.getSeparator());
    }

    @Override
    public void put(String key, ValueModel model) {
        int i = this.find(key);
        if (i == -1) {
            throw new RuntimeException("key not found: " + key + ". Cannot add keys in this implementation.");
        }
        Entry e = this.entries[i];
        ArrayList<String> list = new ArrayList<String>();
        for (String s : model.getValues()) {
            list.add(s);
        }
        e.setValues(list);
        e.setComment(model.getComments());
        e.setSeparator(model.getSeparator());
    }

    @Override
    public void forEach(BiConsumer<String, ValueModel> action) {
        for (Entry model : this.entries) {
            action.accept(model.getKey(), model);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.find(key) != -1;
    }

    @Override
    public boolean hasNonEmptyValue(String key) {
        String val = this.get(key);
        return val.trim().length() > 0;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean hasKeyLike(String leftEdge) {
        for (Entry model : this.entries) {
            if (!model.getKey().startsWith(leftEdge)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMatchingKeys(String regex) {
        ArrayList<String> array = new ArrayList<String>();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry model : this.entries) {
                if (!model.getKey().matches(regex)) continue;
                array.add(model.getKey());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return array;
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteKey(String key) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties merge(Properties props) {
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            Map<String, ValueModel> map = props.asMap();
            map.forEach((? super K k, ? super V v) -> this.put((String)k, (ValueModel)v));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    @Override
    public Properties slice(String keyBase) {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        for (Entry model : this.entries) {
            if (!model.getKey().startsWith(keyBase)) continue;
            impl.put(model);
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ValueModel> asMap() {
        LinkedHashMap<String, ValueModel> map = new LinkedHashMap<String, ValueModel>();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry model : this.entries) {
                map.put(model.getKey(), model);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> asFlattenedMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry model : this.entries) {
                map.put(model.getKey(), model.getValue());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    @Override
    public List<KeyValueModel> asList() {
        ArrayList<KeyValueModel> list = new ArrayList<KeyValueModel>();
        for (Entry e : this.entries) {
            list.add(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.util.Properties asLegacy() {
        java.util.Properties legacy = new java.util.Properties();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry e : this.entries) {
                legacy.put(e.getKey(), e.getValue());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return legacy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties asciiToNative() {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry model : this.entries) {
                List<String> values = model.getValues();
                ArrayList<String> newValues = new ArrayList<String>();
                if (values.size() > 0) {
                    values.forEach((? super T item) -> {
                        String newVal = new AsciiToNativeFilter((String)item).read();
                        newValues.add(newVal);
                    });
                }
                String comments = model.getComments().comments;
                StringBuffer buf = new StringBuffer();
                if (comments != null && comments.length() > 4) {
                    buf.append(new AsciiToNativeFilter(comments).read());
                }
                Comment newComments = new Comment(buf.toString());
                impl.put(new Entry(model.getKey(), model.getSeparator(), newComments, newValues));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return impl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties nativeToAscii() {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        Entry[] entryArray = this.entries;
        synchronized (this.entries) {
            for (Entry model : this.entries) {
                List<String> values = model.getValues();
                ArrayList<String> newValues = new ArrayList<String>();
                if (values.size() > 0) {
                    values.forEach((? super T item) -> newValues.add(new NativeToAsciiFilter().write((String)item).getResult()));
                }
                String comments = model.getComments().comments;
                StringBuffer buf = new StringBuffer();
                if (comments != null && comments.length() > 4) {
                    buf.append(new NativeToAsciiFilter().write(comments).getResult());
                }
                Comment newComments = new Comment(buf.toString());
                impl.put(new Entry(model.getKey(), model.getSeparator(), newComments, newValues));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return impl;
        }
    }

    @Override
    public String toXML() {
        return OutputAdapter.toXML(this);
    }

    @Override
    public String toJSON() {
        return OutputAdapter.toJSON(this);
    }

    @Override
    public String toYAML() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsUnicodeEscape() {
        for (Entry model : this.entries) {
            if (!model.containsUnicodeEscape()) continue;
            return true;
        }
        return false;
    }
}

