/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.impl;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.io.AsciiToNativeFilter;
import asia.redact.bracket.properties.io.NativeToAsciiFilter;
import asia.redact.bracket.properties.io.OutputAdapter;
import asia.redact.bracket.properties.values.Comment;
import asia.redact.bracket.properties.values.Entry;
import asia.redact.bracket.properties.values.KeyValueModel;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class ListBackedPropertiesImpl
implements Properties,
Serializable {
    private static final long serialVersionUID = 1L;
    protected List<KeyValueModel> list = new ArrayList<KeyValueModel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int find(String key) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.list.get(i).getKey().equals(key)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String get(String key) {
        return this.list.get(this.find(key)).getValue();
    }

    @Override
    public String get(String key, String defaultVal) {
        int index = this.find(key);
        if (index == -1) {
            return defaultVal;
        }
        return this.list.get(index).getValue();
    }

    @Override
    public List<String> getValues(String key) {
        return this.list.get(this.find(key)).getValues();
    }

    @Override
    public Comment getComments(String key) {
        return this.list.get(this.find(key)).getComments();
    }

    @Override
    public char getSeparator(String key) {
        return this.list.get(this.find(key)).getSeparator();
    }

    @Override
    public ValueModel getValueModel(String key) {
        return this.list.get(this.find(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String ... values) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            if (this.containsKey(key)) {
                int index = this.find(key);
                this.list.remove(index);
                this.list.add(index, new Entry(key, values));
            } else {
                this.list.add(new Entry(key, values));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Comment comment, String ... values) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            if (this.containsKey(key)) {
                int index = this.find(key);
                this.list.remove(index);
                this.list.add(index, new Entry(key, comment, values));
            } else {
                this.list.add(new Entry(key, comment, values));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, char separator, Comment comment, String ... values) {
        ArrayList<String> listVals = new ArrayList<String>();
        for (String s : values) {
            listVals.add(s);
        }
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            if (this.containsKey(key)) {
                int index = this.find(key);
                this.list.remove(index);
                this.list.add(index, new Entry(key, separator, comment, listVals));
            } else {
                this.list.add(new Entry(key, separator, comment, listVals));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(KeyValueModel model) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            if (this.containsKey(model.getKey())) {
                int index = this.find(model.getKey());
                this.list.remove(index);
                this.list.add(index, model);
            } else {
                this.list.add(model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, ValueModel model) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            if (this.containsKey(key)) {
                int index = this.find(key);
                this.list.remove(index);
                this.list.add(index, new Entry(key, model.getSeparator(), model.getComments(), model.getValues()));
            } else {
                this.list.add(new Entry(key, model.getSeparator(), model.getComments(), model.getValues()));
            }
        }
    }

    @Override
    public void forEach(BiConsumer<String, ValueModel> action) {
        for (KeyValueModel model : this.list) {
            action.accept(model.getKey(), model);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.find(key) != -1;
    }

    @Override
    public boolean hasNonEmptyValue(String key) {
        String val = this.get(key);
        return val.trim().length() > 0;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean hasKeyLike(String leftEdge) {
        for (KeyValueModel model : this.list) {
            if (!model.getKey().startsWith(leftEdge)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMatchingKeys(String regex) {
        ArrayList<String> array = new ArrayList<String>();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (KeyValueModel model : this.list) {
                if (!model.getKey().matches(regex)) continue;
                array.add(model.getKey());
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteKey(String key) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            int index = this.find(key);
            if (index != -1) {
                this.list.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties merge(Properties props) {
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            Map<String, ValueModel> map = props.asMap();
            map.forEach((? super K k, ? super V v) -> this.put((String)k, (ValueModel)v));
        }
        return this;
    }

    @Override
    public Properties slice(String keyBase) {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        for (KeyValueModel model : this.list) {
            if (!model.getKey().startsWith(keyBase)) continue;
            impl.put(model);
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ValueModel> asMap() {
        LinkedHashMap<String, ValueModel> map = new LinkedHashMap<String, ValueModel>();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (KeyValueModel model : this.list) {
                map.put(model.getKey(), model);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> asFlattenedMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (KeyValueModel model : this.list) {
                map.put(model.getKey(), model.getValue());
            }
        }
        return map;
    }

    @Override
    public List<KeyValueModel> asList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.util.Properties asLegacy() {
        java.util.Properties legacy = new java.util.Properties();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            this.list.forEach((? super T item) -> legacy.put(item.getKey(), item.getValue()));
        }
        return legacy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties asciiToNative() {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (KeyValueModel model : this.list) {
                List<String> values = model.getValues();
                ArrayList<String> newValues = new ArrayList<String>();
                if (values.size() > 0) {
                    values.forEach((? super T item) -> {
                        String newVal = new AsciiToNativeFilter((String)item).read();
                        newValues.add(newVal);
                    });
                }
                String comments = model.getComments().comments;
                StringBuffer buf = new StringBuffer();
                if (comments != null && comments.length() > 4) {
                    buf.append(new AsciiToNativeFilter(comments).read());
                }
                Comment newComments = new Comment(buf.toString());
                impl.put(new Entry(model.getKey(), model.getSeparator(), newComments, newValues));
            }
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties nativeToAscii() {
        ListBackedPropertiesImpl impl = new ListBackedPropertiesImpl();
        List<KeyValueModel> list = this.list;
        synchronized (list) {
            for (KeyValueModel model : this.list) {
                List<String> values = model.getValues();
                ArrayList<String> newValues = new ArrayList<String>();
                if (values.size() > 0) {
                    values.forEach((? super T item) -> newValues.add(new NativeToAsciiFilter().write((String)item).getResult()));
                }
                String comments = model.getComments().comments;
                StringBuffer buf = new StringBuffer();
                if (comments != null && comments.length() > 4) {
                    buf.append(new NativeToAsciiFilter().write(comments).getResult());
                }
                Comment newComments = new Comment(buf.toString());
                impl.put(new Entry(model.getKey(), model.getSeparator(), newComments, newValues));
            }
        }
        return impl;
    }

    @Override
    public String toXML() {
        return OutputAdapter.toXML(this);
    }

    @Override
    public String toJSON() {
        return OutputAdapter.toJSON(this);
    }

    @Override
    public String toYAML() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsUnicodeEscape() {
        for (KeyValueModel model : this.list) {
            if (!model.containsUnicodeEscape()) continue;
            return true;
        }
        return false;
    }
}

