/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.adapter;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.adapter.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.List;

public class TypesAdapter
implements Types {
    final Properties props;

    public TypesAdapter(Properties props) {
        this.props = props;
    }

    @Override
    public String stringValue(String key) {
        return this.props.get(key);
    }

    @Override
    public char[] passwordValue(String key) {
        return this.props.get(key).toCharArray();
    }

    @Override
    public int intValue(String key) {
        return Integer.parseInt(this.props.get(key));
    }

    @Override
    public boolean booleanValue(String key) {
        String val = this.props.get(key);
        if (Boolean.parseBoolean(val)) {
            return true;
        }
        if (val == null || val.equals("")) {
            return false;
        }
        if (val.toLowerCase().trim().equals("enabled")) {
            return true;
        }
        if (val.toLowerCase().trim().equals("ok")) {
            return true;
        }
        if (val.toLowerCase().trim().equals("on")) {
            return true;
        }
        return val.toLowerCase().trim().equals("1");
    }

    @Override
    public long longValue(String key) {
        return Long.parseLong(this.props.get(key));
    }

    @Override
    public Date dateValue(String key) {
        String val = this.props.get(key);
        if (val.trim().length() != 13) {
            throw new RuntimeException("Value does not look like a long that could be used as a date");
        }
        return new Date(this.longValue(key));
    }

    @Override
    public float floatValue(String key) {
        return Float.parseFloat(this.props.get(key));
    }

    @Override
    public short shortValue(String key) {
        return Short.parseShort(this.props.get(key));
    }

    @Override
    public byte byteValue(String key) {
        return Byte.parseByte(this.props.get(key));
    }

    @Override
    public Date dateValue(String key, String format) throws ParseException {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.parse(this.props.get(key));
    }

    @Override
    public List<String> listValue(String key) {
        String[] items;
        ArrayList<String> l = new ArrayList<String>();
        String val = this.props.get(key);
        for (String s : items = val.split(" ")) {
            l.add(s);
        }
        return l;
    }

    @Override
    public List<String> listValue(String key, String delimiter) {
        String[] items;
        ArrayList<String> l = new ArrayList<String>();
        String val = this.props.get(key);
        for (String s : items = val.split(delimiter)) {
            l.add(s);
        }
        return l;
    }

    @Override
    public BitSet bitsetValue(String key) {
        String value = this.props.get(key).trim();
        BitSet set = new BitSet(value.length());
        for (int i = 0; i < value.length(); ++i) {
            set.set(i, value.charAt(i) == '1');
        }
        return set;
    }

    @Override
    public BigInteger bigValue(String key) {
        return new BigInteger(this.props.get(key).trim());
    }

    @Override
    public BigDecimal bigDecimalValue(String key) {
        return new BigDecimal(this.props.get(key).trim());
    }

    @Override
    public void put(String key, String val) {
        this.props.put(key, val);
    }

    @Override
    public void put(String key, char[] pass) {
        this.props.put(key, new String(pass));
    }

    @Override
    public void put(String key, int val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, BigInteger bi) {
        this.props.put(key, String.valueOf(bi));
    }

    @Override
    public void put(String key, BigDecimal bd) {
        this.props.put(key, String.valueOf(bd));
    }

    @Override
    public void put(String key, float val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, long val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, double val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, boolean val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, char val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, byte val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, short val) {
        this.props.put(key, String.valueOf(val));
    }

    @Override
    public void put(String key, char delimiter, List<String> values) {
        StringBuilder b = new StringBuilder();
        values.forEach(item -> {
            b.append((String)item);
            b.append(delimiter);
        });
        b.deleteCharAt(b.length() - 1);
    }

    @Override
    public void put(String key, List<String> values) {
        this.put(key, ' ', values);
    }
}

