/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.adapter;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.adapter.Sec;
import asia.redact.bracket.util.Obfuscater;
import java.nio.charset.StandardCharsets;

public class SecAdapter
implements Sec {
    final Properties props;
    final Obfuscater actor;

    public SecAdapter(Properties props) {
        this.props = props;
        this.actor = new Obfuscater();
    }

    public SecAdapter(Properties props, char[] password) {
        this.props = props;
        this.actor = new Obfuscater(password);
    }

    @Override
    public void obfuscate(String key) {
        String val = this.props.get(key);
        if (key != null && !key.equals("")) {
            String obfuscated = this.actor.encrypt(val);
            this.props.put(key, obfuscated);
        }
    }

    @Override
    public void deobfuscate(String key) {
        String val = this.props.get(key);
        if (key != null && !key.equals("")) {
            String deobfuscated = this.actor.decrypt(val);
            this.props.put(key, deobfuscated);
        }
    }

    @Override
    public char[] deobfuscateToChar(String key) {
        String val = this.props.get(key);
        return this.actor.decryptToChar(val, StandardCharsets.UTF_8);
    }

    @Override
    public void encrypt(String key) {
        String encVal = this.actor.encrypt(this.props.get(key));
        this.props.put(key, encVal);
    }

    @Override
    public void decrypt(String key) {
        String rawVal = this.actor.decrypt(this.props.get(key));
        this.props.put(key, rawVal);
    }

    @Override
    public char[] decryptToChar(String key) {
        return this.actor.decryptToChar(this.props.get(key));
    }

    @Override
    public void clearPassword() {
        this.actor.clearPassword();
    }
}

