/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.adapter;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.adapter.Dot;
import asia.redact.bracket.properties.values.ValueModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotAdapter
implements Dot {
    Properties props;
    protected Pattern dotIntegerPattern = Pattern.compile("\\.(\\d+)");

    public DotAdapter(Properties props) {
        this.props = props;
    }

    @Override
    public List<String> getListKeys(String keyBase) {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> keys = this.props.asMap().keySet();
        for (String k : keys) {
            String remainder;
            Matcher matcher;
            if (!k.startsWith(keyBase) || !(matcher = this.dotIntegerPattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
            list.add(k);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> valueList(String keyBase) {
        ArrayList<String> list = new ArrayList<String>();
        TreeMap<Integer, String> numberedMap = new TreeMap<Integer, String>();
        Map<String, ValueModel> map = this.props.asMap();
        Set<String> keys = map.keySet();
        for (String k : keys) {
            String remainder;
            Matcher matcher;
            if (!k.startsWith(keyBase) || !(matcher = this.dotIntegerPattern.matcher(remainder = k.substring(keyBase.length(), k.length()))).matches()) continue;
            Integer keyInt = Integer.parseInt(matcher.group(1));
            numberedMap.put(keyInt, map.get(k).getValue());
        }
        if (numberedMap.size() == 0) {
            return list;
        }
        Set numberKeySet = numberedMap.keySet();
        for (Integer i : numberKeySet) {
            list.add((String)numberedMap.get(i));
        }
        return list;
    }

    @Override
    public String generateClasspath(String keyBase) {
        List<String> list = this.valueList(keyBase);
        StringBuffer classpath = new StringBuffer();
        int i = 0;
        for (String s : list) {
            classpath.append(s);
            if (i < list.size() - 1) {
                classpath.append(File.pathSeparator);
            }
            ++i;
        }
        return classpath.toString();
    }

    @Override
    public String delimitedList(String keyBase, String delim) {
        List<String> list = this.valueList(keyBase);
        StringBuffer b = new StringBuffer();
        int i = 0;
        for (String s : list) {
            b.append(s);
            if (i < list.size() - 1) {
                b.append(delim);
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String dotList(String keyBase) {
        return this.delimitedList(keyBase, ".");
    }

    @Override
    public void putList(String keyBase, List<?> items) {
        for (int i = 0; i < items.size(); ++i) {
            StringBuffer buf = new StringBuffer();
            buf.append(keyBase);
            buf.append(".");
            buf.append(i);
            this.props.put(buf.toString(), String.valueOf(items.get(i)));
        }
    }

    public void putList(String keyBase, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            StringBuffer buf = new StringBuffer();
            buf.append(keyBase);
            buf.append(".");
            buf.append(i);
            this.props.put(buf.toString(), items[i]);
        }
    }
}

