/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.impl.ListBackedPropertiesImpl;
import asia.redact.bracket.properties.impl.PropertiesImpl;
import asia.redact.bracket.properties.impl.SortedPropertiesImpl;
import asia.redact.bracket.properties.line.Line;
import asia.redact.bracket.properties.line.LineScanner;
import asia.redact.bracket.properties.values.BasicValueModel;
import java.util.Comparator;

public class PropertiesParser {
    public final int OPTION_LIST_BACKED_IMPL = 16;
    public final int OPTION_FILE_BACKED_IMPL = 32;
    final LineScanner scanner;
    Properties props;
    boolean concurrent;
    int options;

    public PropertiesParser(LineScanner scanner) {
        this.scanner = scanner;
        this.concurrent = false;
        this.options = 0;
    }

    public PropertiesParser(LineScanner scanner, int options) {
        this.scanner = scanner;
        this.concurrent = false;
        this.options = options;
        if (options == 16) {
            this.props = new ListBackedPropertiesImpl();
        }
    }

    public PropertiesParser(LineScanner scanner, boolean concurrent, int options) {
        this.scanner = scanner;
        this.concurrent = concurrent;
        this.options = options;
        if (options == 16) {
            this.props = new ListBackedPropertiesImpl();
        }
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public PropertiesParser parse(Comparator<CharSequence> comparator) {
        this.props = new SortedPropertiesImpl(this.concurrent, comparator).init();
        return this.parse();
    }

    public PropertiesParser parse() {
        if (this.props == null) {
            this.props = new PropertiesImpl(this.concurrent).init();
        }
        Line line = null;
        String key = null;
        BasicValueModel model = new BasicValueModel();
        boolean hasContinuation = false;
        while ((line = this.scanner.line()) != null) {
            if (hasContinuation) {
                model.addValue(line.logicalLineContents());
                if (line.hasContinuation()) continue;
                hasContinuation = false;
                this.props.put(key, model);
                key = null;
                model = new BasicValueModel();
                continue;
            }
            if (line.isEmptyLine() || line.isPrivateComment()) continue;
            if (line.isCommentLine()) {
                if (key != null) {
                    this.props.put(key, model);
                    key = null;
                    model = new BasicValueModel();
                }
                model.addComment(line.commentContents());
                continue;
            }
            if (!line.isNaturalLine()) continue;
            if (key != null) {
                this.props.put(key, model);
                key = null;
                model = new BasicValueModel();
            }
            String[] parts = line.naturalLineContents();
            key = parts[0];
            model.setSeparator(parts[1].charAt(0));
            hasContinuation = line.hasContinuation();
            model.addValue(parts[2]);
        }
        if (key != null) {
            this.props.put(key, model);
        }
        return this;
    }

    public Properties getProperties() {
        return this.props;
    }
}

