/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class AccessorMethodSetter {
    public final Logger log = Logger.getLogger(AccessorMethodSetter.class);
    private final Pattern setterPattern = Pattern.compile("set[A-Z][a-zA-Z0-9]+");
    final Class<?> clazz;
    final Object instance;
    final String identifier;
    final String value;
    private String listDelimiter;
    private Exception exception;
    private boolean success;

    public AccessorMethodSetter(Class<?> clazz, Object instance, String identifier) {
        this.clazz = clazz;
        this.instance = instance;
        this.identifier = identifier;
        this.value = null;
        this.listDelimiter = " ";
    }

    public AccessorMethodSetter(Class<?> clazz, Object instance, String identifier, String value) {
        this.clazz = clazz;
        this.instance = instance;
        this.identifier = identifier;
        this.value = value;
        this.listDelimiter = " ";
    }

    public boolean success() {
        return this.success;
    }

    public Exception getException() {
        return this.exception;
    }

    private String setify() {
        Matcher match = this.setterPattern.matcher(this.identifier);
        if (match.matches()) {
            return this.identifier;
        }
        StringBuffer buf = new StringBuffer("set");
        char start = this.identifier.charAt(0);
        buf.append(Character.toUpperCase(start));
        if (this.identifier.length() > 1) {
            buf.append(this.identifier.substring(1));
        }
        return buf.toString();
    }

    public void set(Object obj) {
        Method[] allMethods;
        this.log.debug((Object)("set: " + obj));
        if (this.identifier == null || this.identifier.length() == 0) {
            this.exception = new RuntimeException("identifier cannot be null or zero length");
            this.success = false;
            return;
        }
        if (this.clazz == null || this.instance == null) {
            this.exception = new RuntimeException("class or instance cannot be null.");
            this.success = false;
            return;
        }
        String preparedName = this.setify();
        this.log.debug((Object)("prepared method name = " + preparedName));
        for (Method m : allMethods = this.clazz.getMethods()) {
            if (!m.getName().equals(preparedName)) continue;
            this.log.debug((Object)("Found method " + m));
            Class<?>[] pType = m.getParameterTypes();
            if (pType.length != 1) continue;
            this.log.debug((Object)"********* setup for call to invoke() **********");
            this.log.debug((Object)("class for the setter = " + this.clazz.getName()));
            this.log.debug((Object)("instance we are calling set on = " + this.instance));
            this.log.debug((Object)("Type param's expected class = " + pType[0].getName()));
            this.log.debug((Object)("Object's actual class = " + obj.getClass().getName()));
            if (!pType[0].isAssignableFrom(obj.getClass())) continue;
            try {
                m.invoke(this.instance, obj);
                this.success = true;
                this.log.debug((Object)"******** Success ***********");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public void set() throws InstantiationException, IllegalAccessException {
        Method[] allMethods;
        if (this.identifier == null || this.identifier.length() == 0) {
            this.exception = new RuntimeException("identifier cannot be null or zero length");
            this.success = false;
            return;
        }
        if (this.value == null) {
            this.exception = new RuntimeException("value cannot be null");
            this.success = false;
            return;
        }
        if (this.clazz == null || this.instance == null) {
            this.exception = new RuntimeException("class or instance cannot be null.");
            this.success = false;
            return;
        }
        String preparedName = this.setify();
        Method setMethod = null;
        String parameterizedArgType = null;
        for (Method m : allMethods = this.clazz.getMethods()) {
            Type[] paramTypes;
            if (!m.getName().equals(preparedName) || (paramTypes = m.getGenericParameterTypes()).length != 1) continue;
            Type paramType = paramTypes[0];
            if (paramType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)paramType;
                Type[] actual = pt.getActualTypeArguments();
                Class c = (Class)actual[0];
                parameterizedArgType = c.getName();
            }
            setMethod = m;
            break;
        }
        Class<?>[] pType = setMethod.getParameterTypes();
        ArrayList<Object> param = null;
        if (pType[0].getName().equals("java.lang.String")) {
            param = this.value;
        } else if (pType[0].getName().equals("int")) {
            param = Integer.valueOf(this.value);
        } else if (pType[0].getName().equals("boolean")) {
            param = Boolean.valueOf(this.value);
        } else if (pType[0].getName().equals("double")) {
            param = Double.valueOf(this.value);
        } else if (pType[0].getName().equals("long")) {
            param = Long.valueOf(this.value);
        } else if (pType[0].getName().equals("float")) {
            param = Float.valueOf(this.value);
        } else if (pType[0].getName().equals("char")) {
            param = Character.valueOf(this.value.charAt(0));
        } else if (pType[0].getName().equals("[C")) {
            param = (ArrayList<Object>)this.value.toCharArray();
        } else if (pType[0].getName().equals("java.util.Date")) {
            Date date = new Date();
            date.setTime(Long.valueOf(this.value));
            param = date;
        } else if (pType[0].getName().equals("java.util.List")) {
            String[] split;
            ArrayList<String> rawList = new ArrayList<String>();
            for (String s : split = this.value.split(this.listDelimiter)) {
                rawList.add(s);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (parameterizedArgType.equals("java.lang.String")) {
                list.addAll(rawList);
            } else if (parameterizedArgType.equals("java.lang.Integer")) {
                for (String s : rawList) {
                    list.add(Integer.parseInt(s));
                }
            } else if (parameterizedArgType.equals("int")) {
                for (String s : rawList) {
                    list.add(Integer.parseInt(s));
                }
            } else if (parameterizedArgType.equals("java.lang.Double")) {
                for (String s : rawList) {
                    list.add(Double.parseDouble(s));
                }
            } else if (parameterizedArgType.equals("double")) {
                for (String s : rawList) {
                    list.add(Double.parseDouble(s));
                }
            } else if (parameterizedArgType.equals("java.lang.Float")) {
                for (String s : rawList) {
                    list.add(Float.valueOf(Float.parseFloat(s)));
                }
            } else if (parameterizedArgType.equals("float")) {
                for (String s : rawList) {
                    list.add(Float.valueOf(Float.parseFloat(s)));
                }
            } else if (parameterizedArgType.equals("java.lang.Long")) {
                for (String s : rawList) {
                    list.add(Long.parseLong(s));
                }
            } else if (parameterizedArgType.equals("long")) {
                for (String s : rawList) {
                    list.add(Long.parseLong(s));
                }
            } else if (parameterizedArgType.equals("java.lang.Boolean")) {
                for (String s : rawList) {
                    list.add(Boolean.valueOf(s));
                }
            } else if (parameterizedArgType.equals("boolean")) {
                for (String s : rawList) {
                    list.add(Boolean.valueOf(s));
                }
            } else if (parameterizedArgType.equals("java.util.Date")) {
                for (String s : rawList) {
                    Date date = new Date();
                    date.setTime(Long.valueOf(this.value));
                    list.add(date);
                }
            } else {
                if (parameterizedArgType.startsWith("java")) {
                    throw new RuntimeException("Not Yet Supported As List Type: " + parameterizedArgType);
                }
                if (parameterizedArgType.startsWith("sun")) {
                    throw new RuntimeException("Not Yet Supported As List Type: " + parameterizedArgType);
                }
            }
            param = list;
        }
        try {
            setMethod.invoke(this.instance, param);
            this.success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
            this.success = false;
        }
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    public void setListDelimiter(String delimiter) {
        this.listDelimiter = delimiter;
    }
}

