/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.mgmt;

import asia.redact.bracket.properties.ExternalizedLocaleStringBuilder;
import asia.redact.bracket.properties.LocaleStringBuilder;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.mgmt.Attributes;
import asia.redact.bracket.properties.mgmt.PropertiesReference;
import asia.redact.bracket.properties.mgmt.ReferenceType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class LoadList {
    protected final List<PropertiesReference> list = new ArrayList<PropertiesReference>();
    protected final Properties props = new PropertiesImpl();
    protected final Attributes attribs;

    public LoadList() {
        this.attribs = new Attributes();
    }

    public LoadList(Attributes attribs) {
        this.attribs = attribs;
    }

    public void addReference(File file) {
        try {
            this.list.add(new PropertiesReference(ReferenceType.EXTERNAL, file.getCanonicalPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addReference(ReferenceType type, String path) {
        this.list.add(new PropertiesReference(type, path));
    }

    public void addReference(PropertiesReference ref) {
        this.list.add(ref);
    }

    public void load() {
        if (this.attribs.useCompatibilityMode) {
            Properties.Factory.mode = Properties.Mode.Compatibility;
        } else if (this.attribs.useLineMode) {
            Properties.Factory.mode = Properties.Mode.Line;
        } else if (this.attribs.useCompatibilityMode) {
            Properties.Factory.mode = Properties.Mode.Compatibility;
        } else if (this.attribs.useExplicitMode) {
            Properties.Factory.mode = Properties.Mode.Explicit;
        } else if (this.attribs.useBasicTokenMode) {
            Properties.Factory.mode = Properties.Mode.BasicToken;
        }
        block10: for (PropertiesReference ref : this.list) {
            switch (ref.type) {
                case CLASSLOADED: {
                    List<String> list;
                    Object builder;
                    if (this.attribs.locale != null) {
                        builder = new LocaleStringBuilder(ref.data, this.attribs.locale);
                        list = ((LocaleStringBuilder)builder).getSearchStrings();
                        for (String localizedPath : list) {
                            try {
                                this.loadFromClasspath(localizedPath);
                            }
                            catch (Exception x) {}
                        }
                        continue block10;
                    }
                    this.loadFromClasspath(ref.data);
                    break;
                }
                case DIRECT: {
                    this.loadFromDirect(ref.data);
                    break;
                }
                case EXTERNAL: {
                    List<String> list;
                    Object builder;
                    if (this.attribs.locale != null) {
                        builder = new ExternalizedLocaleStringBuilder(ref.data, this.attribs.locale);
                        list = ((ExternalizedLocaleStringBuilder)builder).getValidPaths();
                        for (String localizedPath : list) {
                            try {
                                this.loadFromFile(localizedPath);
                            }
                            catch (Exception x) {}
                        }
                        continue block10;
                    }
                    this.loadFromFile(ref.data);
                    break;
                }
                case COMMANDLINE_OVERRIDE: {
                    this.loadFromSystemProps(ref.data);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type: " + ref);
                }
            }
        }
        if (this.attribs.insertResultsIntoSystemProperties) {
            this.props.mergeIntoSystemProperties();
        }
    }

    private void loadFromSystemProps(String key) {
        String val = System.getProperty(key);
        if (val != null) {
            this.props.put(key, val);
        }
    }

    private void loadFromClasspath(String path) {
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path)) == null) {
            throw new RuntimeException("path " + path + " was not found as a ResourceStream");
        }
        this.props.merge(Properties.Factory.getInstance(in));
    }

    private void loadFromDirect(String data) {
        StringReader reader = new StringReader(data);
        this.props.merge(Properties.Factory.getInstance(reader));
    }

    private void loadFromFile(String path) {
        File file = new File(path);
        if (this.attribs.scanForPropertiesFiles) {
            if (file.isDirectory()) {
                File[] mylist;
                for (File f : mylist = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.contains(".properties");
                    }
                })) {
                    if (Properties.Factory.mode == Properties.Mode.Compatibility) {
                        this.props.merge(Properties.Factory.getInstance(f, Charset.forName("ISO-8859-1")));
                        continue;
                    }
                    this.props.merge(Properties.Factory.getInstance(f, Charset.forName("UTF-8")));
                }
            } else if (Properties.Factory.mode == Properties.Mode.Compatibility) {
                this.props.merge(Properties.Factory.getInstance(file, Charset.forName("ISO-8859-1")));
            } else {
                this.props.merge(Properties.Factory.getInstance(file, Charset.forName("UTF-8")));
            }
        } else {
            if (!file.isFile()) {
                try {
                    throw new RuntimeException("File " + file.getCanonicalPath() + " is not a file we can read. Bailing.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (Properties.Factory.mode == Properties.Mode.Compatibility) {
                this.props.merge(Properties.Factory.getInstance(file, Charset.forName("ISO-8859-1")));
            } else {
                this.props.merge(Properties.Factory.getInstance(file, Charset.forName("UTF-8")));
            }
        }
    }

    public List<PropertiesReference> getList() {
        return this.list;
    }

    public Properties getProps() {
        return this.props;
    }

    public Attributes getAttribs() {
        return this.attribs;
    }
}

