/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.line;

import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.PropertiesTokenType;
import asia.redact.bracket.properties.line.LineEnding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Line
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String text;
    final long index;
    final LineEnding ending;

    public Line(String text, long index, LineEnding ending) {
        this.text = text;
        this.index = index;
        this.ending = ending;
    }

    private PropertiesToken nominalEnding() {
        boolean has = this.hasContinuation();
        switch (this.ending) {
            case CRLF: {
                if (has) {
                    return new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\r\n");
                }
                return new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\r\n");
            }
            case CR: {
                if (has) {
                    return new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\r");
                }
                return new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\r");
            }
            case LF: {
                if (has) {
                    return new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\n");
                }
                return new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\n");
            }
        }
        return null;
    }

    public List<PropertiesToken> tokens() {
        ArrayList<PropertiesToken> list = new ArrayList<PropertiesToken>();
        if (this.isEmptyLine()) {
            list.add(this.nominalEnding());
            return list;
        }
        if (this.isPrivateComment()) {
            return list;
        }
        if (this.isCommentLine()) {
            list.add(new PropertiesToken(PropertiesTokenType.COMMENT, this.commentContents()));
            list.add(this.nominalEnding());
            return list;
        }
        if (this.isNaturalLine()) {
            String[] parts = this.naturalLineContents();
            list.add(new PropertiesToken(PropertiesTokenType.KEY, parts[0]));
            list.add(new PropertiesToken(PropertiesTokenType.SEPARATOR, parts[1]));
            list.add(new PropertiesToken(PropertiesTokenType.VALUE, parts[2]));
            list.add(this.nominalEnding());
        } else {
            list.add(new PropertiesToken(PropertiesTokenType.VALUE, this.logicalLineContents()));
            list.add(this.nominalEnding());
        }
        return list;
    }

    public boolean hasContinuation() {
        if (this.text.length() == 0) {
            return false;
        }
        return this.text.charAt(this.text.length() - 1) == '\\';
    }

    public boolean isPrivateComment() {
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (Character.isWhitespace(ch) || ch != '#' || this.text.length() <= i + 2 || this.text.charAt(i + 1) != ';' || this.text.charAt(i + 2) != ';') continue;
            return true;
        }
        return false;
    }

    public String logicalLineContents() {
        int countBlank = 0;
        for (int i = 0; i < this.text.length() && Character.isWhitespace(this.text.charAt(i)); ++i) {
            ++countBlank;
        }
        if (this.hasContinuation()) {
            if (countBlank > 0) {
                return this.text.substring(countBlank, this.text.length() - 1);
            }
            return this.text.substring(0, this.text.length() - 1);
        }
        if (countBlank > 0) {
            return this.text.substring(countBlank, this.text.length());
        }
        return this.text.substring(0, this.text.length());
    }

    public boolean isNaturalLine() {
        int sepIndex = -1;
        char previous = '\u0000';
        char ch = '\u0000';
        for (int i = 0; i < this.text.length(); ++i) {
            previous = ch;
            ch = this.text.charAt(i);
            if (ch != '=' && ch != ':' || previous == '\\') continue;
            sepIndex = i;
            break;
        }
        return sepIndex >= 0;
    }

    public boolean isCommentLine() {
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch == '#' || ch == '!';
        }
        return false;
    }

    public boolean isEmptyLine() {
        return this.text == null || this.text.trim().length() == 0;
    }

    public String commentContents() {
        int startComment = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '#' || ch == '!') {
                startComment = i;
                break;
            }
            throw new RuntimeException("not a comment line, use method isCommentLine() as guard");
        }
        return this.text.substring(startComment + 1);
    }

    public String[] naturalLineContents() {
        String[] retVals = new String[3];
        int countBlank = 0;
        for (int i = 0; i < this.text.length() && Character.isWhitespace(this.text.charAt(i)); ++i) {
            ++countBlank;
        }
        String line = null;
        line = countBlank > 0 ? this.text.substring(countBlank) : this.text;
        int sepIndex = -1;
        char previous = '\u0000';
        char ch = '\u0000';
        boolean sawEscapedDelimiter = false;
        for (int i = 0; i < line.length(); ++i) {
            previous = ch;
            ch = line.charAt(i);
            if ((ch == '=' || ch == ':') && previous == '\\') {
                sawEscapedDelimiter = true;
            }
            if (ch != '=' && ch != ':' || previous == '\\') continue;
            sepIndex = i;
            break;
        }
        if (sepIndex == -1) {
            throw new RuntimeException("not a natural line (no key), use method isNaturalLine() as guard");
        }
        if (sawEscapedDelimiter) {
            String key = line.substring(0, sepIndex);
            previous = '\u0000';
            ch = '\u0000';
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                previous = ch;
                ch = line.charAt(i);
                if ((ch == '=' || ch == ':') && previous == '\\') {
                    b.deleteCharAt(b.length() - 1);
                }
                b.append(ch);
            }
            retVals[0] = b.toString();
        } else {
            retVals[0] = line.substring(0, sepIndex);
        }
        if (retVals[0].endsWith(" ")) {
            retVals[0] = retVals[0].trim();
        }
        retVals[1] = String.valueOf(line.charAt(sepIndex));
        retVals[2] = this.hasContinuation() ? line.substring(sepIndex + 1, line.length() - 1) : line.substring(sepIndex + 1);
        return retVals;
    }

    public String getText() {
        return this.text;
    }

    public long getIndex() {
        return this.index;
    }

    public LineEnding getEnding() {
        return this.ending;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.index);
        buf.append(", ");
        buf.append(this.text);
        buf.append(", ");
        buf.append((Object)this.ending);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ending == null ? 0 : this.ending.hashCode());
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (this.ending != other.ending) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

