/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.alt;

import asia.redact.bracket.properties.BasicValueModel;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesParser2;
import asia.redact.bracket.properties.line.Line;
import asia.redact.bracket.properties.line.LineScanner;

public class DotPropertiesParser
extends PropertiesParser2 {
    public DotPropertiesParser(LineScanner scanner) {
        super(scanner);
    }

    public DotPropertiesParser(LineScanner scanner, Properties props) {
        super(scanner, props);
    }

    @Override
    public void parse() {
        String fullKey = null;
        Line line = null;
        String key = null;
        BasicValueModel model = new BasicValueModel();
        boolean hasContinuation = false;
        while ((line = this.scanner.line()) != null) {
            String[] parts;
            if (hasContinuation) {
                model.addValue(line.logicalLineContents());
                if (line.hasContinuation()) continue;
                hasContinuation = false;
            }
            if (line.isEmptyLine() || line.isPrivateComment()) continue;
            if (line.isCommentLine()) {
                if (key != null) {
                    this.props.getPropertyMap().put(key, model);
                    key = null;
                    model = new BasicValueModel();
                }
                model.addComment(line.commentContents());
                continue;
            }
            if (!line.isNaturalLine()) continue;
            if (key != null) {
                this.props.getPropertyMap().put(key, model);
                key = null;
                model = new BasicValueModel();
            }
            if (!(key = (parts = line.naturalLineContents())[0]).startsWith(".")) {
                fullKey = key;
            } else {
                key = fullKey + key;
            }
            model.setSeparator(parts[1].charAt(0));
            hasContinuation = line.hasContinuation();
            model.addValue(parts[2]);
        }
        if (key != null) {
            this.props.getPropertyMap().put(key, model);
        }
    }
}

