/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.InputAdapter;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.PropertiesTokenType;
import asia.redact.bracket.util.AsciiToNativeFilterReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PropertiesLexer {
    final String input;
    int index;
    final List<PropertiesToken> list = new ArrayList<PropertiesToken>();
    private final Lock lock = new ReentrantLock();

    public PropertiesLexer(String input) {
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(new StringReader(input));
            StringBuilder builder = new StringBuilder();
            char[] array = new char[8120];
            int count = 0;
            try {
                while ((count = reader.read(array)) != -1) {
                    builder.append(array, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = builder.toString();
        } else {
            this.input = input;
        }
    }

    public PropertiesLexer(Reader in) {
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(in);
            StringBuilder builder = new StringBuilder();
            char[] array = new char[8120];
            int count = 0;
            try {
                while ((count = reader.read(array)) != -1) {
                    builder.append(array, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = builder.toString();
        } else {
            this.input = new InputAdapter().asString(in);
        }
    }

    public PropertiesLexer(File in, Charset charset) {
        String str = new InputAdapter().asString(in, charset);
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(new StringReader(str));
            StringBuilder builder = new StringBuilder();
            char[] array = new char[8120];
            int count = 0;
            try {
                while ((count = reader.read(array)) != -1) {
                    builder.append(array, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = builder.toString();
        } else {
            this.input = str;
        }
    }

    public PropertiesLexer(InputStream in) {
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(new InputStreamReader(in));
            StringBuilder builder = new StringBuilder();
            char[] array = new char[8120];
            int count = 0;
            try {
                while ((count = reader.read(array)) != -1) {
                    builder.append(array, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = builder.toString();
        } else {
            this.input = new InputAdapter().asString(in);
        }
    }

    public PropertiesLexer(InputStream in, Charset charset) {
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            AsciiToNativeFilterReader reader = new AsciiToNativeFilterReader(new InputStreamReader(in, charset));
            StringBuilder builder = new StringBuilder();
            char[] array = new char[8120];
            int count = 0;
            try {
                while ((count = reader.read(array)) != -1) {
                    builder.append(array, 0, count);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.input = builder.toString();
        } else {
            this.input = new InputAdapter().asString(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lex() {
        this.lock.lock();
        long count = 0L;
        try {
            if (this.input == null) {
                return;
            }
            PropertiesToken lastEol = null;
            while (this.hasNext()) {
                StringBuffer buf = new StringBuffer();
                PropertiesToken eol = null;
                while (this.hasNext() && (eol = this.scanLineBreak()) == null) {
                    buf.append(this.next());
                }
                this.analyzeLine(buf.toString(), lastEol, count);
                ++count;
                if (eol == null) {
                    return;
                }
                lastEol = eol;
                this.list.add(eol);
                this.index += eol.text.length();
            }
        }
        finally {
            this.list.add(PropertiesToken.eof());
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeLine(String buf, PropertiesToken tok, long count) {
        this.lock.lock();
        try {
            int countBlank = 0;
            for (int i = 0; i < buf.length() && Character.isWhitespace(buf.charAt(i)); ++i) {
                ++countBlank;
            }
            if (countBlank > 0) {
                buf = buf.substring(countBlank);
            }
            if (buf.isEmpty()) {
                return;
            }
            if (buf.length() > 3 && buf.charAt(0) == '#' && buf.charAt(1) == ';' && buf.charAt(2) == ';') {
                if (Properties.Factory.mode != Properties.Mode.Explicit) return;
                String meta = buf.substring(3, buf.length());
                this.list.add(new PropertiesToken(PropertiesTokenType.META_DATA, meta));
            }
            char ch = buf.charAt(0);
            switch (ch) {
                case '!': 
                case '#': {
                    this.comment(buf);
                    return;
                }
                default: {
                    this.scanKeyValue(buf, tok);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanKeyValue(String buf, PropertiesToken eol) {
        this.lock.lock();
        try {
            int sepIndex = -1;
            char previous = '\u0000';
            char ch = '\u0000';
            boolean sawEscapedDelimiter = false;
            for (int i = 0; i < buf.length(); ++i) {
                previous = ch;
                ch = buf.charAt(i);
                if ((ch == '=' || ch == ':') && previous == '\\') {
                    sawEscapedDelimiter = true;
                }
                if (ch != '=' && ch != ':' || previous == '\\') continue;
                sepIndex = i;
                break;
            }
            if (sepIndex == -1) {
                if (eol != null && eol.type == PropertiesTokenType.LOGICAL_LINE_BREAK) {
                    this.list.add(new PropertiesToken(PropertiesTokenType.VALUE, buf));
                }
            } else {
                if (sawEscapedDelimiter) {
                    String key = buf.substring(0, sepIndex);
                    previous = '\u0000';
                    ch = '\u0000';
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < key.length(); ++i) {
                        previous = ch;
                        ch = buf.charAt(i);
                        if ((ch == '=' || ch == ':') && previous == '\\') {
                            b.deleteCharAt(b.length() - 1);
                        }
                        b.append(ch);
                    }
                    this.list.add(new PropertiesToken(PropertiesTokenType.KEY, b.toString().trim()));
                } else {
                    this.list.add(new PropertiesToken(PropertiesTokenType.KEY, buf.substring(0, sepIndex).trim()));
                }
                this.list.add(new PropertiesToken(PropertiesTokenType.SEPARATOR, String.valueOf(buf.charAt(sepIndex))));
                this.list.add(new PropertiesToken(PropertiesTokenType.VALUE, buf.substring(sepIndex + 1, buf.length())));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comment(String buf) {
        this.lock.lock();
        try {
            this.list.add(new PropertiesToken(PropertiesTokenType.COMMENT, buf));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesToken scanLineBreak() {
        this.lock.lock();
        try {
            if (this.la(0).charValue() == '\\' && this.la(1).charValue() == '\r' && this.la(2).charValue() == '\n') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\r\n");
                return propertiesToken;
            }
            if (this.la(0).charValue() == '\\' && this.la(1).charValue() == '\r') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\r");
                return propertiesToken;
            }
            if (this.la(0).charValue() == '\\' && this.la(1).charValue() == '\n') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.LOGICAL_LINE_BREAK, "\\\n");
                return propertiesToken;
            }
            if (this.la(0).charValue() == '\r' && this.la(1).charValue() == '\n') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\r\n");
                return propertiesToken;
            }
            if (this.la(0).charValue() == '\r') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\r");
                return propertiesToken;
            }
            if (this.la(0).charValue() == '\n') {
                PropertiesToken propertiesToken = new PropertiesToken(PropertiesTokenType.NATURAL_LINE_BREAK, "\n");
                return propertiesToken;
            }
            PropertiesToken propertiesToken = null;
            return propertiesToken;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNext() {
        this.lock.lock();
        try {
            boolean bl = this.index < this.input.length();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char next() {
        this.lock.lock();
        try {
            if (this.index >= this.input.length()) {
                throw new RuntimeException("problem, index >= " + this.input.length());
            }
            char ch = this.input.charAt(this.index);
            ++this.index;
            char c = ch;
            return c;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Character la(int count) {
        this.lock.lock();
        try {
            Character c = Character.valueOf(this.input.charAt(this.index + count));
            return c;
        }
        catch (IndexOutOfBoundsException x) {
            Character c = Character.valueOf('\u0000');
            return c;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<PropertiesToken> getList() {
        return this.list;
    }
}

