/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.AsciiOutputFormat;
import asia.redact.bracket.properties.BasicOutputFormat;
import asia.redact.bracket.properties.GenerateXMLNodeVisitor;
import asia.redact.bracket.properties.GroupParams;
import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.NodeVisitor;
import asia.redact.bracket.properties.OutputFormat;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;

public class OutputAdapter {
    final Properties properties;
    static final String lineSeparator = System.getProperty("line.separator");

    public OutputAdapter(Properties properties) {
        this.properties = properties;
    }

    public void writeTo(File file) {
        this.writeTo(file, (OutputFormat)new BasicOutputFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file, OutputFormat format) {
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            this.writeTo(out, format);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, OutputFormat format, Charset charset) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, charset);
            this.writeTo(writer, format);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file, OutputFormat format, Charset charset) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
            this.writeTo(writer, format);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void writeAsciiTo(File file, OutputFormat format) {
        this.writeTo(file, format, Charset.forName("ISO-8859-1"));
    }

    public void writeAsciiTo(File file) {
        this.writeTo(file, (OutputFormat)new AsciiOutputFormat(), Charset.forName("ISO-8859-1"));
    }

    public void writeTo(Writer writer, OutputFormat format) throws IOException {
        Set<Map.Entry<String, ValueModel>> set = this.properties.getPropertyMap().entrySet();
        writer.append(format.formatContentType());
        writer.append(format.formatHeader());
        for (Map.Entry<String, ValueModel> e : set) {
            String key = e.getKey();
            ValueModel model = e.getValue();
            writer.append(format.format(key, model.getSeparator(), model.getValues(), model.getComments()));
        }
        writer.append(format.formatFooter());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, (OutputFormat)new BasicOutputFormat());
    }

    public void writeAsXml(Writer out) {
        try {
            if (Properties.Factory.mode == Properties.Mode.Compatibility) {
                out.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            } else {
                out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            }
            out.append(lineSeparator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GroupParams params = new GroupParams();
        params.rootNodeName = "properties";
        Node node = this.properties.getTree(params);
        this.visit(node, 0, new GenerateXMLNodeVisitor(out));
    }

    protected void visit(Node node, int level, NodeVisitor func) {
        func.setLevel(level);
        func.pre(node);
        func.action(node);
        ++level;
        for (Node childNode : node.getChildren()) {
            this.visit(childNode, level, func);
        }
        func.post(node);
    }

    public static final String toString(Properties props) {
        OutputAdapter out = new OutputAdapter(props);
        StringWriter writer = new StringWriter();
        try {
            out.writeTo(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

