/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import java.io.Serializable;
import java.nio.charset.Charset;

public class ContentType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mimeType;
    private String charsetName;

    public ContentType() {
        this.mimeType = "text/x-java-properties";
        this.charsetName = "UTF-8";
    }

    public ContentType(String mimeType, String charsetName) {
        this.mimeType = mimeType;
        this.charsetName = charsetName;
    }

    public boolean validate() {
        if (this.mimeType == null || this.mimeType.equals("")) {
            return false;
        }
        if (this.charsetName == null || this.charsetName.equals("")) {
            return false;
        }
        try {
            Charset.forName(this.charsetName);
        }
        catch (Exception x) {
            return false;
        }
        return this.mimeType.equals("text/x-java-properties") || this.mimeType.equals("text/x-java-dot-properties");
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charsetName == null ? 0 : this.charsetName.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.charsetName == null ? other.charsetName != null : !this.charsetName.equals(other.charsetName)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }

    public String toString() {
        return "content=\"" + this.mimeType + "; charset=" + this.charsetName + "\"";
    }

    public static ContentType getCompatibilityContentType() {
        return new ContentType("text/x-java-properties", "ISO-8895-1");
    }

    public static ContentType getDotPropertiesContentType() {
        return new ContentType("text/x-java-dot-properties", "UTF-8");
    }
}

