/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Comment;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.util.NativeToAsciiFilter;
import java.util.ArrayList;
import java.util.List;

public class BasicValueModel
implements ValueModel {
    private static final long serialVersionUID = 1L;
    static final String lineSeparator = System.getProperty("line.separator");
    protected final List<String> comments;
    protected final List<String> values;
    protected char separator = (char)61;

    public BasicValueModel() {
        this.comments = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    public BasicValueModel(String ... value) {
        this();
        for (String v : value) {
            this.values.add(v);
        }
    }

    public BasicValueModel(char sep, String ... value) {
        this();
        this.separator = sep;
        for (String v : value) {
            this.values.add(v);
        }
    }

    public BasicValueModel(Comment comment, String ... value) {
        this();
        this.comments.add(comment.comment);
        for (String v : value) {
            this.values.add(v);
        }
    }

    public BasicValueModel(Comment comment, char sep, String ... value) {
        this();
        this.separator = sep;
        this.comments.add(comment.comment);
        for (String v : value) {
            this.values.add(v);
        }
    }

    BasicValueModel(List<String> comments, List<String> values) {
        this.comments = comments;
        this.values = values;
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + this.separator;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicValueModel other = (BasicValueModel)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.separator != other.separator) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void clearComments() {
        this.comments.clear();
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        for (String value : this.values) {
            b.append(value);
        }
        return b.toString();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public String asKeyValueRep(String key) {
        StringBuffer buf;
        block7: {
            buf = new StringBuffer();
            if (this.comments.size() > 0) {
                for (String com : this.comments) {
                    buf.append(com);
                    buf.append(lineSeparator);
                }
            }
            buf.append(key);
            buf.append(this.separator);
            int count = 0;
            if (this.values.size() == 0) break block7;
            if (this.values.size() == 1) {
                for (String val : this.values) {
                    buf.append(val);
                    buf.append(lineSeparator);
                }
            } else {
                for (String val : this.values) {
                    buf.append(val);
                    if (count < this.values.size() - 1) {
                        buf.append("\\");
                    }
                    buf.append(lineSeparator);
                    ++count;
                }
            }
        }
        return buf.toString();
    }

    @Override
    public String toXML(int spaces) {
        if (Properties.Factory.mode == Properties.Mode.Compatibility) {
            return this.toXMLCompatibilityMode(spaces);
        }
        StringBuilder sp = new StringBuilder();
        for (int i = 0; i <= spaces; ++i) {
            sp.append(" ");
        }
        StringBuilder builder = new StringBuilder();
        for (String comment : this.comments) {
            builder.append(sp.toString());
            builder.append("<c><![CDATA[").append(comment).append("]]></c>").append(lineSeparator);
        }
        builder.append(sp.toString());
        builder.append("<s>").append(this.separator).append("</s>").append(lineSeparator);
        for (String value : this.values) {
            builder.append(sp.toString());
            if (value != null && !value.equals("")) {
                builder.append("<v><![CDATA[").append(value).append("]]></v>").append(lineSeparator);
                continue;
            }
            builder.append("<v/>").append(lineSeparator);
        }
        return builder.toString();
    }

    protected String toXMLCompatibilityMode(int spaces) {
        String encoded;
        StringBuilder sp = new StringBuilder();
        for (int i = 0; i <= spaces; ++i) {
            sp.append(" ");
        }
        StringBuilder builder = new StringBuilder();
        for (String comment : this.comments) {
            builder.append(sp.toString());
            encoded = new NativeToAsciiFilter(comment).getResult();
            builder.append("<c><![CDATA[").append(encoded).append("]]></c>").append(lineSeparator);
        }
        builder.append(sp.toString());
        builder.append("<s>").append(this.separator).append("</s>").append(lineSeparator);
        for (String value : this.values) {
            builder.append(sp.toString());
            if (value != null && !value.equals("")) {
                encoded = new NativeToAsciiFilter(value).getResult();
                builder.append("<v><![CDATA[").append(encoded).append("]]></v>").append(lineSeparator);
                continue;
            }
            builder.append("<v/>").append(lineSeparator);
        }
        return builder.toString();
    }
}

