/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.ContentType;
import asia.redact.bracket.properties.ValueModel;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractPropertiesBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ContentType contentType;
    protected AbstractMap<String, ValueModel> map;
    protected final Lock lock = new ReentrantLock();

    public AbstractPropertiesBase() {
        this.contentType = new ContentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        this.lock.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(String value) {
        this.lock.lock();
        try {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        this.lock.lock();
        try {
            ValueModel valueModel = this.map.remove(key);
            return valueModel;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        this.lock.lock();
        try {
            Set<String> set = this.map.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ValueModel> values() {
        this.lock.lock();
        try {
            Collection<ValueModel> collection = this.map.values();
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPropertiesBase other = (AbstractPropertiesBase)obj;
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

