/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import java.io.IOException;

public class NativeToAsciiFilter {
    final String lineBreak = System.getProperty("line.separator");
    StringBuffer out;

    public NativeToAsciiFilter() {
        this.out = new StringBuffer();
    }

    public NativeToAsciiFilter(StringBuffer buf) {
        this.out = buf;
    }

    public NativeToAsciiFilter write(char[] buf) {
        this.write(buf, 0, buf.length);
        return this;
    }

    public NativeToAsciiFilter write(String str) {
        try {
            this.write(str, 0, str.length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public NativeToAsciiFilter write(char[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            if (buf[i] > '\u007f') {
                int j;
                this.out.append('\\');
                this.out.append('u');
                String hex = Integer.toHexString(buf[i]);
                StringBuilder hex4 = new StringBuilder(hex);
                hex4.reverse();
                int length = 4 - hex4.length();
                for (j = 0; j < length; ++j) {
                    hex4.append('0');
                }
                for (j = 0; j < 4; ++j) {
                    this.out.append(hex4.charAt(3 - j));
                }
                continue;
            }
            this.out.append(buf[i]);
        }
        return this;
    }

    public NativeToAsciiFilter write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
        return this;
    }

    public String getResult() {
        return this.out.toString();
    }
}

