/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class AsciiToNativeFilterReader
extends FilterReader {
    private char[] trailChars = null;

    public AsciiToNativeFilterReader(Reader in) {
        super(in);
    }

    public int read(char[] buf, int off, int len) throws IOException {
        int n;
        int numChars = 0;
        int retChars = 0;
        char[] cBuf = new char[len];
        boolean cOffset = false;
        boolean eof = false;
        if (this.trailChars != null) {
            for (int i = 0; i < this.trailChars.length; ++i) {
                cBuf[i] = this.trailChars[i];
            }
            numChars = this.trailChars.length;
            this.trailChars = null;
        }
        if ((n = this.in.read(cBuf, numChars, len - numChars)) < 0) {
            eof = true;
            if (numChars == 0) {
                return -1;
            }
        } else {
            numChars += n;
        }
        int i = 0;
        while (i < numChars) {
            char c;
            if ((c = cBuf[i++]) != '\\' || eof && numChars <= 5) {
                buf[retChars++] = c;
                continue;
            }
            int remaining = numChars - i;
            if (remaining < 5) {
                this.trailChars = new char[1 + remaining];
                this.trailChars[0] = c;
                for (int j = 0; j < remaining; ++j) {
                    this.trailChars[1 + j] = cBuf[i + j];
                }
                break;
            }
            if ((c = cBuf[i++]) != 'u') {
                buf[retChars++] = 92;
                buf[retChars++] = c;
                continue;
            }
            char rc = '\u0000';
            boolean isUE = true;
            try {
                rc = (char)Integer.parseInt(new String(cBuf, i, 4), 16);
            }
            catch (NumberFormatException x) {
                isUE = false;
            }
            if (isUE) {
                buf[retChars++] = rc;
                i += 4;
                continue;
            }
            buf[retChars++] = 92;
            buf[retChars++] = 117;
        }
        return retChars;
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return buf[0];
    }
}

