/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.mgmt;

import asia.redact.bracket.properties.mgmt.ServerLocalizedFileInfo;

public class ServerLocale {
    String environment;
    String cluster;
    String instance;
    String variant;

    public ServerLocale(String environment, String cluster, String instance, String variant) {
        this.environment = environment;
        this.cluster = cluster;
        this.variant = variant;
        this.instance = instance;
    }

    public ServerLocale(String environment, String cluster, String instance) {
        this.environment = environment;
        this.cluster = cluster;
        this.instance = instance;
    }

    public ServerLocale(String environment, String cluster) {
        this.environment = environment;
        this.cluster = cluster;
    }

    public ServerLocale(String environment) {
        this.environment = environment;
    }

    public ServerLocale() {
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String sec) {
        this.variant = sec;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isWildcard(this.environment)) {
            buf.append("_");
        } else if (!this.isNotSet(this.environment)) {
            buf.append("_");
            buf.append(this.environment);
        }
        if (this.isWildcard(this.cluster)) {
            buf.append("_");
        } else if (!this.isNotSet(this.cluster)) {
            buf.append("_");
            buf.append(this.cluster);
        }
        if (this.isWildcard(this.instance)) {
            buf.append("_");
        } else if (!this.isNotSet(this.instance)) {
            buf.append("_");
            buf.append(this.instance);
        }
        if (this.isWildcard(this.variant)) {
            buf.append("_");
        } else if (!this.isNotSet(this.variant)) {
            buf.append("_");
            buf.append(this.variant);
        }
        return buf.toString();
    }

    boolean isWildcard(String s) {
        if (s == null) {
            return false;
        }
        return s.equals("");
    }

    boolean isNotSet(String s) {
        return s == null;
    }

    boolean isSet(String s) {
        return s != null;
    }

    boolean matchEnvironment(String env) {
        if (this.isWildcard(env)) {
            return true;
        }
        return this.environment.equals(env);
    }

    boolean matchCluster(String cluster) {
        if (this.isWildcard(cluster)) {
            return true;
        }
        return this.cluster.equals(cluster);
    }

    boolean matchInstance(String inst) {
        if (this.isWildcard(inst)) {
            return true;
        }
        return this.instance.equals(inst);
    }

    public boolean includes(ServerLocale locale) {
        if (!this.matchEnvironment(locale.getEnvironment())) {
            return false;
        }
        if (!this.matchCluster(locale.getCluster())) {
            return false;
        }
        return this.matchInstance(locale.getInstance());
    }

    public static ServerLocalizedFileInfo fromFileName(String fileName) {
        if (!fileName.endsWith(".properties")) {
            throw new RuntimeException("fileName must be a properties file, end in .properties");
        }
        ServerLocalizedFileInfo info = new ServerLocalizedFileInfo();
        info.extension = ".properties";
        int firstUnderscore = fileName.indexOf("_");
        if (firstUnderscore == -1) {
            info.baseName = fileName.substring(11);
            info.locale = new ServerLocale();
        } else {
            info.baseName = fileName.substring(0, firstUnderscore - 1);
            String pat = fileName.substring(firstUnderscore - 1, fileName.length() - 11);
            info.locale = ServerLocale.fromString(pat);
        }
        return info;
    }

    public static ServerLocale fromString(String input) {
        ServerLocale locale = new ServerLocale();
        if (input == "" || input == null) {
            return locale;
        }
        int underscoreCount = 0;
        StringBuffer environment = new StringBuffer();
        StringBuffer cluster = new StringBuffer();
        StringBuffer instance = new StringBuffer();
        StringBuffer variant = new StringBuffer();
        for (char ch : input.toCharArray()) {
            if (ch == '_') {
                ++underscoreCount;
                continue;
            }
            if (underscoreCount == 1) {
                environment.append(ch);
            } else if (underscoreCount == 2) {
                cluster.append(ch);
            } else if (underscoreCount == 3) {
                instance.append(ch);
            }
            if (underscoreCount != 4) continue;
            variant.append(ch);
        }
        if (environment.length() > 0) {
            locale.setEnvironment(environment.toString());
        }
        if (cluster.length() > 0) {
            locale.setCluster(cluster.toString());
        }
        if (instance.length() > 0) {
            locale.setInstance(instance.toString());
        }
        if (variant.length() > 0) {
            locale.setVariant(variant.toString());
        }
        if (underscoreCount == 4) {
            if (environment.length() == 0) {
                locale.setEnvironment("");
            }
            if (cluster.length() == 0) {
                locale.setCluster("");
            }
            if (instance.length() == 0) {
                locale.setInstance("");
            }
            if (variant.length() == 0) {
                locale.setVariant("");
            }
        }
        if (underscoreCount == 3) {
            if (environment.length() == 0) {
                locale.setEnvironment("");
            }
            if (cluster.length() == 0) {
                locale.setCluster("");
            }
            if (instance.length() == 0) {
                locale.setInstance("");
            }
        }
        if (underscoreCount == 2) {
            if (environment.length() == 0) {
                locale.setEnvironment("");
            }
            if (cluster.length() == 0) {
                locale.setCluster("");
            }
        }
        if (underscoreCount == 1 && environment.length() == 0) {
            locale.setEnvironment("");
        }
        return locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cluster == null ? 0 : this.cluster.hashCode());
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerLocale other = (ServerLocale)obj;
        if (this.cluster == null ? other.cluster != null : !this.cluster.equals(other.cluster)) {
            return false;
        }
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        return !(this.variant == null ? other.variant != null : !this.variant.equals(other.variant));
    }
}

