/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.mgmt;

import asia.redact.bracket.properties.mgmt.ServerLocale;
import asia.redact.bracket.properties.mgmt.ServerLocaleBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostnameServerLocaleBuilder
extends ServerLocaleBuilder {
    String pattern;

    public HostnameServerLocaleBuilder() {
        this.pattern = "(u[dtap])\\-(\\w+)\\-(\\w+)(.+?)";
    }

    public HostnameServerLocaleBuilder(String pattern) {
        this.pattern = pattern;
    }

    public ServerLocale findServerLocale() {
        Pattern pat = Pattern.compile(this.pattern);
        String inet = this.fromInet();
        Matcher matcher = pat.matcher(inet);
        ServerLocale loc = null;
        if (matcher.matches()) {
            loc = new ServerLocale();
            String env = matcher.group(1);
            if (env.equals("ud")) {
                loc.setEnvironment("dev");
            } else if (env.equals("ut")) {
                loc.setEnvironment("test");
            } else if (env.equals("ua")) {
                loc.setEnvironment("acceptance");
            } else if (env.equals("up")) {
                loc.setEnvironment("prod");
            }
        } else {
            throw new RuntimeException("Looks like either your pattern is wrong or your server's hostname is not amenable to this approach");
        }
        String cluster = matcher.group(2);
        loc.setCluster(cluster);
        String instance = matcher.group(3);
        loc.setInstance(instance);
        return loc;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

