/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties.alt;

import asia.redact.bracket.properties.BasicOutputFormat;
import asia.redact.bracket.properties.OutputFormat;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

public class DotOutputAdapter {
    final Properties properties;
    static final String lineSeparator = System.getProperty("line.separator");

    public DotOutputAdapter(Properties properties, boolean sortRequired) {
        this.properties = sortRequired ? Properties.Factory.sortedInstance(properties) : properties;
    }

    public void writeTo(File file) {
        this.writeTo(file, (OutputFormat)new BasicOutputFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file, OutputFormat format) {
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            this.writeTo(out, format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void writeTo(Writer writer, OutputFormat format) throws IOException {
        Set<Map.Entry<String, ValueModel>> set = this.properties.getPropertyMap().entrySet();
        writer.append(format.formatHeader());
        String baseKey = null;
        for (Map.Entry<String, ValueModel> e : set) {
            String key = e.getKey();
            if (baseKey == null) {
                baseKey = key;
            } else if (key.contains(baseKey)) {
                key = key.substring(baseKey.length(), key.length());
            }
            ValueModel model = e.getValue();
            writer.append(format.format(key, model.getSeparator(), model.getValues(), model.getComments()));
        }
        writer.append(format.formatFooter());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, (OutputFormat)new BasicOutputFormat());
    }
}

