/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.properties.line.Line;
import asia.redact.bracket.properties.line.LineScanner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PropertiesParser2 {
    protected final LineScanner scanner;
    protected final Properties props;
    private final Lock lock = new ReentrantLock();

    public PropertiesParser2(LineScanner scanner) {
        this.scanner = scanner;
        this.props = new PropertiesImpl();
    }

    public PropertiesParser2(LineScanner scanner, Properties props) {
        this.scanner = scanner;
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        try {
            this.lock.lock();
            Line line = null;
            String key = null;
            ValueModel model = new ValueModel();
            boolean hasContinuation = false;
            while ((line = this.scanner.line()) != null) {
                if (hasContinuation) {
                    model.addValue(line.logicalLineContents());
                    if (line.hasContinuation()) continue;
                    hasContinuation = false;
                }
                if (line.isEmptyLine() || line.isPrivateComment()) continue;
                if (line.isCommentLine()) {
                    if (key != null) {
                        this.props.getPropertyMap().put(key, model);
                        key = null;
                        model = new ValueModel();
                    }
                    model.addComment(line.commentContents());
                    continue;
                }
                if (!line.isNaturalLine()) continue;
                if (key != null) {
                    this.props.getPropertyMap().put(key, model);
                    key = null;
                    model = new ValueModel();
                }
                String[] parts = line.naturalLineContents();
                key = parts[0];
                model.setSeparator(parts[1].charAt(0));
                hasContinuation = line.hasContinuation();
                model.addValue(parts[2]);
            }
            if (key != null) {
                this.props.getPropertyMap().put(key, model);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Properties getProperties() {
        return this.props;
    }
}

