/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.PropertiesTokenType;
import asia.redact.bracket.properties.ValueModel;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesParser {
    final Stack<PropertiesToken> tokens;
    final Properties properties;
    private final Lock lock = new ReentrantLock();
    private boolean trimValues;

    public PropertiesParser(List<PropertiesToken> tokens, Properties properties) {
        this.tokens = new Stack();
        for (int i = tokens.size() - 1; i > -1; --i) {
            this.tokens.add(tokens.get(i));
        }
        this.properties = properties;
    }

    public PropertiesParser(List<PropertiesToken> tokens) {
        this.tokens = new Stack();
        for (int i = tokens.size() - 1; i > -1; --i) {
            this.tokens.add(tokens.get(i));
        }
        this.properties = new PropertiesImpl();
    }

    public PropertiesParser(Stack<PropertiesToken> tokens) {
        this.tokens = tokens;
        this.properties = new PropertiesImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.lock.lock();
        try {
            String key = null;
            ValueModel value = new ValueModel();
            while (this.tokens.size() > 0) {
                if (this.peek().type == PropertiesTokenType.EOF) {
                    this.pop();
                } else {
                    PropertiesToken t;
                    if (this.peek().type == PropertiesTokenType.NATURAL_LINE_BREAK) {
                        this.pop();
                        if (key == null || value.getValues().size() <= 0) continue;
                        this.properties.getPropertyMap().put(key, value);
                        value = new ValueModel();
                        key = null;
                        continue;
                    }
                    if (this.peek().type == PropertiesTokenType.COMMENT) {
                        t = this.pop();
                        value.addComment(t.text);
                        this.pop();
                        continue;
                    }
                    if (this.peek().type == PropertiesTokenType.KEY) {
                        t = this.pop();
                        key = t.text.trim();
                        if (this.peek().type == PropertiesTokenType.NATURAL_LINE_BREAK) {
                            this.pop();
                            value.addValue("");
                            this.properties.getPropertyMap().put(key, value);
                            value = new ValueModel();
                            key = null;
                            continue;
                        }
                        if (this.peek().type == PropertiesTokenType.SEPARATOR) {
                            t = this.pop();
                            value.setSeparator(t.text.charAt(0));
                        }
                    }
                    if (this.peek().type != PropertiesTokenType.VALUE) continue;
                    t = this.pop();
                    String text = t.text;
                    if (this.peek().type == PropertiesTokenType.NATURAL_LINE_BREAK) {
                        this.pop();
                        if (this.trimValues) {
                            value.addValue(this.trimEndingWhiteSpace(text));
                        } else {
                            value.addValue(text);
                        }
                        this.properties.getPropertyMap().put(key, value);
                        value = new ValueModel();
                        key = null;
                        continue;
                    }
                    if (this.peek().type == PropertiesTokenType.LOGICAL_LINE_BREAK) {
                        value.addValue(text);
                        this.pop();
                        continue;
                    }
                    if (this.peek().type != PropertiesTokenType.EOF) continue;
                    if (this.trimValues) {
                        value.addValue(this.trimEndingWhiteSpace(text));
                    } else {
                        value.addValue(text);
                    }
                    this.pop();
                    this.properties.getPropertyMap().put(key, value);
                    value = new ValueModel();
                    key = null;
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private PropertiesToken peek() {
        try {
            PropertiesToken tok = this.tokens.peek();
            return tok;
        }
        catch (EmptyStackException x) {
            return PropertiesToken.eof();
        }
    }

    private PropertiesToken pop() {
        try {
            PropertiesToken tok = this.tokens.pop();
            return tok;
        }
        catch (EmptyStackException x) {
            return PropertiesToken.eof();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isTrimValues() {
        return this.trimValues;
    }

    public void setTrimValues(boolean trimValues) {
        this.trimValues = trimValues;
    }

    private String trimEndingWhiteSpace(String text) {
        int count = 0;
        for (int i = text.length() - 1; i > -1 && Character.isWhitespace(text.charAt(i)); --i) {
            ++count;
        }
        if (count > 0) {
            return text.substring(0, text.length() - count);
        }
        return text;
    }
}

