/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.AbstractPropertiesBase;
import asia.redact.bracket.properties.GroupParams;
import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.TreeBuilder;
import asia.redact.bracket.properties.TreeSynchronizer;
import asia.redact.bracket.properties.ValueModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesImpl
extends AbstractPropertiesBase
implements Properties {
    public PropertiesImpl() {
        this.initMap();
    }

    protected void initMap() {
        this.map = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(java.util.Properties legacy) {
        this();
        this.lock.lock();
        try {
            Set<Object> set = legacy.keySet();
            for (Object key : set) {
                String val = legacy.getProperty(String.valueOf(key));
                this.put(String.valueOf(key), val);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(URL url) {
        this();
        InputStream in = null;
        this.lock.lock();
        try {
            in = url.openStream();
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(InputStream in) {
        this();
        this.lock.lock();
        try {
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesImpl(Reader in) {
        this();
        this.lock.lock();
        try {
            PropertiesLexer lexer = new PropertiesLexer(in);
            lexer.lex();
            List<PropertiesToken> list = lexer.getList();
            new PropertiesParser(list, this).parse();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        this.lock.lock();
        try {
            ValueModel val = (ValueModel)this.map.get(key);
            if (val == null) {
                throw new RuntimeException("Missing value " + key + ". Normally you would test for the existence of keys by using containsKey(key)");
            }
            String string = val.getValue();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String ... values) {
        this.lock.lock();
        try {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new ValueModel(values));
            } else {
                ValueModel val = (ValueModel)this.map.get(key);
                val.getValues().clear();
                for (String s : values) {
                    val.getValues().add(s);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<String, ValueModel> getPropertyMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComments(String key) {
        this.lock.lock();
        try {
            if (!this.containsKey(key)) {
                List<String> list = null;
                return list;
            }
            List<String> list = this.getPropertyMap().get(key).getComments();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getSeparator(String key) {
        this.lock.lock();
        try {
            if (!this.containsKey(key)) {
                char c = '\u0000';
                return c;
            }
            char c = this.getPropertyMap().get(key).getSeparator();
            return c;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeyGroup(String keyBase) {
        this.lock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : this.map.keySet()) {
                if (s.indexOf(keyBase) != 0) continue;
                list.add(s);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.lock.lock();
        try {
            int prime = 31;
            int result = 1;
            int n = result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.lock.lock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            if (this.getClass() != obj.getClass()) {
                boolean bl = false;
                return bl;
            }
            PropertiesImpl other = (PropertiesImpl)obj;
            if (this.map == null) {
                if (other.map != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.map.equals(other.map)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Properties merge(Properties props) {
        this.merge(props, false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties merge(Properties props, boolean mergeComments) {
        this.lock.lock();
        try {
            Set<String> set = props.getPropertyMap().keySet();
            for (String key : set) {
                if (mergeComments) {
                    List<String> comments = this.getComments(key);
                    List<String> newComments = props.getComments(key);
                    if (comments == null) {
                        comments = new ArrayList<String>();
                    }
                    if (newComments != null) {
                        for (String s : newComments) {
                            comments.add(s);
                        }
                    }
                    ValueModel model = new ValueModel(comments, props.getPropertyMap().get(key).getValues());
                    this.getPropertyMap().put(key, model);
                    continue;
                }
                this.getPropertyMap().put(key, props.getPropertyMap().get(key));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public Node getTree() {
        return this.getTree(new GroupParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getTree(GroupParams params) {
        this.lock.lock();
        try {
            TreeBuilder builder = new TreeBuilder(this, params.rootNodeName);
            Set keys = this.map.keySet();
            for (String key : keys) {
                if (!key.startsWith(params.getPartialKey())) continue;
                ValueModel value = (ValueModel)this.map.get(key);
                builder.createNode(key, value, params.getSeparator());
            }
            Node node = builder.tree();
            return node;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Properties getGroup(GroupParams params) {
        PropertiesImpl impl = new PropertiesImpl();
        for (String key : this.getPropertyMap().keySet()) {
            if (!key.startsWith(params.getPartialKey())) continue;
            ValueModel value = (ValueModel)this.map.get(key);
            impl.getPropertyMap().put(key, value);
        }
        return impl;
    }

    @Override
    public int intValue(String key) {
        return Integer.parseInt(this.get(key));
    }

    @Override
    public long longValue(String key) {
        return Long.parseLong(this.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date dateValue(String key) {
        this.lock.lock();
        try {
            String val = this.get(key);
            if (val.trim().length() != 13) {
                throw new RuntimeException("Value does not look like a long that could be used as a date");
            }
            Date date = new Date(this.longValue(key));
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date dateValue(String key, String format) throws ParseException {
        this.lock.lock();
        try {
            SimpleDateFormat f = new SimpleDateFormat(format);
            Date date = f.parse(this.get(key));
            return date;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue(String key) {
        this.lock.lock();
        try {
            String val = this.get(key);
            boolean bl = val != null && !val.equals("");
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(Node rootNode) {
        this.lock.lock();
        try {
            new TreeSynchronizer(this, rootNode).synch();
        }
        finally {
            this.lock.unlock();
        }
    }
}

