/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.NodeVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;

public class GenerateXMLNodeVisitor
implements NodeVisitor {
    static final String lineSeparator = System.getProperty("line.separator");
    final String NS = "xmlns=\"http://code.google.com/p/bracket-properties\"";
    final Writer writer;
    int level;
    final HashSet<Node> set = new HashSet();

    public GenerateXMLNodeVisitor(Writer writer) {
        this.writer = writer;
    }

    public void pre(Node node) {
        if (!this.set.contains(node)) {
            this.set.add(node);
            ++this.level;
        }
        try {
            this.writer.append(this.spaces());
            this.writer.append("<");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void action(Node node) {
        try {
            this.writer.append(node.getName());
            if (this.level == 1) {
                this.writer.append(" ");
                this.writer.append("xmlns=\"http://code.google.com/p/bracket-properties\"");
            }
            this.writer.append(">");
            this.writer.append(lineSeparator);
            if (node.hasValue()) {
                this.writer.append(node.getValue().toXML(this.level));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void post(Node node) {
        if (this.set.contains(node)) {
            this.set.add(node);
            --this.level;
        }
        try {
            this.writer.append(this.spaces());
            this.writer.append("</").append(node.getName()).append(">").append("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    private String spaces() {
        StringBuilder sp = new StringBuilder();
        for (int i = 0; i < this.level; ++i) {
            sp.append(" ");
        }
        return sp.toString();
    }
}

