/*
 *  This file is part of Bracket Security
 *  Copyright 2011 David R. Smith
 *
 */
package asia.redact.bracket.util;

import java.io.IOException;

/**
 * Wrapper to provide a type for Base64 url-safe variant Strings.
 * 
 * @author Dave
 *
 */
public class Base64UrlSafe {
	
	final String encoded;
	
	public Base64UrlSafe(String encoded) {
		this.encoded = encoded;
	}
	
	public Base64UrlSafe(byte[] bytes) throws IOException{
			encoded = Base64.encodeBytes(bytes, Base64.URL_SAFE);
	}
	
	public String toString() {
		return encoded;
	}
	
	public byte [] decode() throws IOException {
		return Base64.decode(encoded,Base64.URL_SAFE);
	}
}
