/*
 *  This file is part of Bracket Properties
 *  Copyright 2011 David R. Smith
 *
 */
package asia.redact.bracket.properties;


import java.io.Reader;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;

/**
 * Wrapper on the SAXParser stuff - internal
 * 
 * @author Dave
 *
 */
class ParseXML {
	
	Properties props;
	
	public ParseXML(){}
	
	public void parse(Reader reader) {

		BracketPropertiesSAXHandler handler = new BracketPropertiesSAXHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser;
		try {
			parser = factory.newSAXParser();
			InputSource source = new InputSource(reader);
		    parser.parse(source, handler);
		    props = handler.getResult();
		} catch (Exception x){
			throw new RuntimeException("Parsing properties failed: "+x.getMessage());
		}
	}

	public Properties getProps() {
		return props;
	}
	
}
