/*
 * Decompiled with CFR 0.152.
 */
package arte.programar.materialfile.utils;

import androidx.annotation.Nullable;
import arte.programar.materialfile.filter.FileFilter;
import arte.programar.materialfile.utils.FileComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileUtils {
    public static List<File> getFileList(File directory, FileFilter filter) {
        File[] files = directory.listFiles(filter::accept);
        if (files == null) {
            return new ArrayList<File>();
        }
        List<File> result = Arrays.asList(files);
        Collections.sort(result, new FileComparator());
        return result;
    }

    @Nullable
    public static File getParentOrNull(File file) {
        if (file.getParent() == null) {
            return null;
        }
        return file.getParentFile();
    }

    public static boolean isParent(File maybeChild, File possibleParent) {
        if (!possibleParent.exists() || !possibleParent.isDirectory()) {
            return false;
        }
        for (File child = maybeChild; child != null; child = child.getParentFile()) {
            if (!child.equals(possibleParent)) continue;
            return true;
        }
        return false;
    }
}

