/*
 * Decompiled with CFR 0.152.
 */
package arte.programar.materialfile.ui;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import arte.programar.materialfile.R;
import arte.programar.materialfile.filter.FileFilter;
import arte.programar.materialfile.ui.DirectoryAdapter;
import arte.programar.materialfile.ui.ThrottleClickListener;
import arte.programar.materialfile.utils.FileUtils;
import arte.programar.materialfile.widget.EmptyRecyclerView;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public class DirectoryFragment
extends Fragment {
    private static final String ARG_FILE = "arg_file_path";
    private static final String ARG_FILTER = "arg_filter";
    private View mEmptyView;
    private File mFile;
    private FileFilter mFilter;
    private EmptyRecyclerView mDirectoryRecyclerView;
    private DirectoryAdapter mDirectoryAdapter;
    private FileClickListener mFileClickListener;

    static DirectoryFragment getInstance(File file, FileFilter filter) {
        DirectoryFragment instance = new DirectoryFragment();
        Bundle args = new Bundle();
        args.putSerializable(ARG_FILE, (Serializable)file);
        args.putSerializable(ARG_FILTER, (Serializable)filter);
        instance.setArguments(args);
        return instance;
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.mFileClickListener = (FileClickListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mFileClickListener = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_directory, container, false);
        this.mDirectoryRecyclerView = (EmptyRecyclerView)view.findViewById(R.id.directory_recycler_view);
        this.mEmptyView = view.findViewById(R.id.directory_empty_view);
        return view;
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initArgs();
        this.initFilesList();
    }

    private void initFilesList() {
        this.mDirectoryAdapter = new DirectoryAdapter(FileUtils.getFileList(this.mFile, this.mFilter));
        this.mDirectoryAdapter.setOnItemClickListener(new ThrottleClickListener(){

            @Override
            void onItemClickThrottled(View view, int position) {
                if (DirectoryFragment.this.mFileClickListener != null) {
                    DirectoryFragment.this.mFileClickListener.onFileClicked(DirectoryFragment.this.mDirectoryAdapter.getModel(position));
                }
            }
        });
        this.mDirectoryRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mDirectoryRecyclerView.setAdapter(this.mDirectoryAdapter);
        this.mDirectoryRecyclerView.setEmptyView(this.mEmptyView);
    }

    private void initArgs() {
        Bundle arguments = Objects.requireNonNull(this.getArguments());
        if (arguments.containsKey(ARG_FILE)) {
            this.mFile = (File)this.getArguments().getSerializable(ARG_FILE);
        }
        this.mFilter = (FileFilter)this.getArguments().getSerializable(ARG_FILTER);
    }

    static interface FileClickListener {
        public void onFileClicked(File var1);
    }
}

