/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.chart.dataset;

import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.chart.dataset.AbstractDataset;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class TimeSeriesDataset
extends AbstractDataset {
    private static final long serialVersionUID = 10000L;
    public static final Class YEAR = Year.class;
    public static final Class QUARTER = Quarter.class;
    public static final Class MONTH = Month.class;
    public static final Class WEEK = Week.class;
    public static final Class DAY = Day.class;
    public static final Class HOUR = Hour.class;
    public static final Class MINUTE = Minute.class;
    public static final Class SECOND = Second.class;
    public static final Class MILLISECOND = Millisecond.class;
    private PropertyColumn timePeriod = null;
    private final List<AbstractColumn> series = new ArrayList<AbstractColumn>();
    private final Map<AbstractColumn, StringExpression> seriesLabels = new HashMap<AbstractColumn, StringExpression>();
    private Class timePeriodClass = DAY;

    public void setTimePeriod(PropertyColumn timePeriod) {
        this.timePeriod = timePeriod;
    }

    public PropertyColumn getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void addSerie(AbstractColumn column) {
        this.series.add(column);
    }

    public void addSerie(AbstractColumn column, String label) {
        this.addSerie(column, new LiteralExpression(label));
    }

    public void addSerie(AbstractColumn column, StringExpression labelExpression) {
        this.series.add(column);
        this.seriesLabels.put(column, labelExpression);
    }

    public void removeSerie(AbstractColumn column) {
        this.series.remove(column);
        this.seriesLabels.remove(column);
    }

    public void clearSeries() {
        this.series.clear();
        this.seriesLabels.clear();
    }

    public List getSeries() {
        return this.series;
    }

    public void setTimePeriodClass(Class timePeriodClass) {
        this.timePeriodClass = timePeriodClass;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    @Override
    public JRDesignChartDataset transform(DynamicJasperDesign design, String name, JRDesignGroup group, JRDesignGroup parentGroup, Map vars) {
        JRDesignTimeSeriesDataset data = new JRDesignTimeSeriesDataset(null);
        if (this.timePeriodClass != null) {
            data.setTimePeriod(this.timePeriodClass);
        }
        for (AbstractColumn sery : this.series) {
            JRDesignExpression exp3;
            JRDesignTimeSeries serie = new JRDesignTimeSeries();
            JRDesignExpression varExp = TimeSeriesDataset.getExpressionFromVariable((JRDesignVariable)vars.get(sery));
            serie.setValueExpression((JRExpression)varExp);
            JRExpression exp2 = group.getExpression();
            if (this.seriesLabels.containsKey(sery)) {
                exp3 = ExpressionUtils.createAndRegisterExpression(design, "dataset_" + sery.getName() + "_" + name, this.seriesLabels.get(sery));
            } else {
                exp3 = new JRDesignExpression();
                exp3.setText("\"" + sery.getTitle() + "\"");
            }
            exp3.setValueClass(String.class);
            serie.setTimePeriodExpression(exp2);
            serie.setLabelExpression((JRExpression)exp3);
            serie.setSeriesExpression((JRExpression)exp3);
            data.addTimeSeries((JRTimeSeries)serie);
        }
        TimeSeriesDataset.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    @Override
    public List getColumns() {
        return this.series;
    }

    @Override
    public PropertyColumn getColumnsGroup() {
        return this.timePeriod;
    }
}

