/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.chart.dataset;

import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.chart.dataset.AbstractDataset;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXySeries;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class XYDataset
extends AbstractDataset {
    private static final long serialVersionUID = 10000L;
    private PropertyColumn xValue = null;
    private final List<AbstractColumn> series = new ArrayList<AbstractColumn>();
    private final Map<AbstractColumn, StringExpression> seriesLabels = new HashMap<AbstractColumn, StringExpression>();

    public void setXValue(PropertyColumn xValue) {
        this.xValue = xValue;
    }

    public PropertyColumn getXValue() {
        return this.xValue;
    }

    @Override
    public void addSerie(AbstractColumn column) {
        this.series.add(column);
    }

    public void addSerie(AbstractColumn column, String label) {
        this.addSerie(column, new LiteralExpression(label));
    }

    public void addSerie(AbstractColumn column, StringExpression labelExpression) {
        this.series.add(column);
        this.seriesLabels.put(column, labelExpression);
    }

    public void removeSerie(AbstractColumn column) {
        this.series.remove(column);
        this.seriesLabels.remove(column);
    }

    public void clearSeries() {
        this.series.clear();
        this.seriesLabels.clear();
    }

    public List getSeries() {
        return this.series;
    }

    @Override
    public JRDesignChartDataset transform(DynamicJasperDesign design, String name, JRDesignGroup group, JRDesignGroup parentGroup, Map vars) {
        JRDesignXyDataset data = new JRDesignXyDataset(null);
        for (AbstractColumn sery : this.series) {
            JRDesignExpression exp3;
            JRDesignXySeries serie = new JRDesignXySeries();
            JRDesignExpression varExp = XYDataset.getExpressionFromVariable((JRDesignVariable)vars.get(sery));
            serie.setYValueExpression((JRExpression)varExp);
            JRExpression exp2 = group.getExpression();
            if (this.seriesLabels.containsKey(sery)) {
                exp3 = ExpressionUtils.createAndRegisterExpression(design, "dataset_" + sery.getName() + "_" + name, this.seriesLabels.get(sery));
            } else {
                exp3 = new JRDesignExpression();
                exp3.setText("\"" + sery.getTitle() + "\"");
            }
            exp3.setValueClass(String.class);
            serie.setXValueExpression(exp2);
            serie.setLabelExpression((JRExpression)exp3);
            serie.setSeriesExpression((JRExpression)exp3);
            data.addXySeries((JRXySeries)serie);
        }
        XYDataset.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    @Override
    public List getColumns() {
        return this.series;
    }

    @Override
    public PropertyColumn getColumnsGroup() {
        return this.xValue;
    }
}

