/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.DJJRDesignHelper;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.ColumnRegistrationManager;
import ar.com.fdvs.dj.core.registration.DJGroupRegistrationManager;
import ar.com.fdvs.dj.core.registration.DJGroupVariableDefRegistrationManager;
import ar.com.fdvs.dj.core.registration.VariableRegistrationManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariableDef;
import ar.com.fdvs.dj.domain.entities.Parameter;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.util.DJCompilerFactory;
import ar.com.fdvs.dj.util.LayoutUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicJasperHelper {
    private static final Log log = LogFactory.getLog(DynamicJasperHelper.class);
    public static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DJ_RESOURCE_BUNDLE = "dj-messages";
    private static final Random random = new Random(System.currentTimeMillis());

    private static void registerEntities(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        Locale locale;
        ColumnRegistrationManager columnRegistrationManager = new ColumnRegistrationManager(jd, dr, layoutManager);
        columnRegistrationManager.registerEntities(dr.getColumns());
        DJGroupRegistrationManager djGroupRegistrationManager = new DJGroupRegistrationManager(jd, dr, layoutManager);
        djGroupRegistrationManager.registerEntities(dr.getColumnsGroups());
        VariableRegistrationManager variableRegistrationManager = new VariableRegistrationManager(jd, dr, layoutManager);
        variableRegistrationManager.registerEntities(dr.getVariables());
        DynamicJasperHelper.registerPercentageColumnsVariables(jd, dr, layoutManager);
        DynamicJasperHelper.registerOtherFields(jd, dr.getFields());
        Locale locale2 = locale = dr.getReportLocale() == null ? Locale.getDefault() : dr.getReportLocale();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested Locale = " + dr.getReportLocale() + ", Locale to use: " + locale));
        }
        ResourceBundle messages = null;
        if (dr.getResourceBundle() != null) {
            try {
                messages = ResourceBundle.getBundle(dr.getResourceBundle(), locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", using default (dj-messages)"));
            }
        }
        if (messages == null) {
            try {
                messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", using default (dj-messages)"));
                try {
                    messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, Locale.ENGLISH);
                }
                catch (MissingResourceException e2) {
                    log.error((Object)("Default messages not found: dj-messages, " + e2.getMessage()), (Throwable)e2);
                    throw new DJException("Default messajes file not found: dj-messagesen.properties", e2);
                }
            }
        }
        jd.getParametersWithValues().put("REPORT_RESOURCE_BUNDLE", messages);
        jd.getParametersWithValues().put("REPORT_LOCALE", locale);
    }

    private static void registerPercentageColumnsVariables(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        for (AbstractColumn column : dr.getColumns()) {
            if (!(column instanceof PercentageColumn)) continue;
            PercentageColumn percentageColumn = (PercentageColumn)column;
            for (DJGroup djGroup : dr.getColumnsGroups()) {
                JRDesignGroup jrGroup = LayoutUtils.getJRDesignGroup(jd, layoutManager, djGroup);
                DJGroupVariableDefRegistrationManager variablesRM = new DJGroupVariableDefRegistrationManager(jd, dr, layoutManager, jrGroup);
                DJGroupVariableDef variable = new DJGroupVariableDef(percentageColumn.getGroupVariableName(djGroup), percentageColumn.getPercentageColumn(), DJCalculation.SUM);
                ArrayList<DJGroupVariableDef> entities = new ArrayList<DJGroupVariableDef>();
                entities.add(variable);
                variablesRM.registerEntities(entities);
            }
        }
    }

    private static void registerOtherFields(DynamicJasperDesign jd, List<ColumnProperty> fields) {
        for (ColumnProperty element : fields) {
            JRDesignField field = new JRDesignField();
            field.setValueClassName(element.getValueClassName());
            field.setName(element.getProperty());
            try {
                jd.addField((JRField)field);
            }
            catch (JRException e) {
                log.warn((Object)e.getMessage());
            }
        }
    }

    protected static DynamicJasperDesign generateJasperDesign(DynamicReport dr) throws CoreException {
        DynamicJasperDesign jd;
        try {
            if (dr.getTemplateFileName() != null) {
                log.info((Object)("about to load template file: " + dr.getTemplateFileName() + ", Attemping to find the file directly in the file system."));
                File file = new File(dr.getTemplateFileName());
                if (file.exists()) {
                    JasperDesign jdesign = JRXmlLoader.load((File)file);
                    jd = DJJRDesignHelper.downCast(jdesign, dr);
                } else {
                    log.info((Object)"Not found: Attemping to find the file in the classpath...");
                    URL url = DynamicJasperHelper.class.getClassLoader().getResource(dr.getTemplateFileName());
                    if (url == null) {
                        throw new CoreException("could not open template file: " + dr.getTemplateFileName());
                    }
                    JasperDesign jdesign = JRXmlLoader.load((InputStream)url.openStream());
                    jd = DJJRDesignHelper.downCast(jdesign, dr);
                }
                DJJRDesignHelper.populateReportOptionsFromDesign(jd, dr);
            } else {
                jd = DJJRDesignHelper.getNewDesign(dr);
            }
            jd.setName("" + jd.getName() + "_" + random.nextInt(10000));
            log.debug((Object)("The name for this report will be: " + jd.getName()));
            jd.setScriptletClass(DJDefaultScriptlet.class.getName());
            DynamicJasperHelper.registerParameters(jd, dr);
        }
        catch (JRException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return jd;
    }

    protected static void registerParameters(DynamicJasperDesign jd, DynamicReport dr) {
        for (Parameter param : dr.getParameters()) {
            JRDesignParameter jrparam = new JRDesignParameter();
            jrparam.setName(param.getName());
            jrparam.setValueClassName(param.getClassName());
            if (param.getDefaultValueExpression() != null) {
                jrparam.setDefaultValueExpression((JRExpression)new JRDesignExpression(param.getDefaultValueExpression()));
            }
            try {
                jd.addParameter((JRParameter)jrparam);
            }
            catch (JRException e) {
                throw new CoreException(e.getMessage(), e);
            }
        }
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds) throws JRException {
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, ds, new HashMap<String, Object>());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Collection collection) throws JRException {
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collection);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap<String, Object>());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, ResultSet resultSet) throws JRException {
        JRResultSetDataSource ds = new JRResultSetDataSource(resultSet);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap<String, Object>());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds, Map<String, Object> _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, _parameters, (JRDataSource)ds);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Connection con, Map<String, Object> _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        if (_parameters == null) {
            _parameters = new HashMap<String, Object>();
        }
        DynamicJasperHelper.visitSubreports(dr, _parameters);
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters, "r");
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr, layoutManager);
        layoutManager.applyLayout(jd, dr);
        JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty("net.sf.jasperreports.compiler.", DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, params, (Connection)con);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Map<String, Object> _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        if (_parameters == null) {
            _parameters = new HashMap<String, Object>();
        }
        DynamicJasperHelper.visitSubreports(dr, _parameters);
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters, "r");
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr, layoutManager);
        layoutManager.applyLayout(jd, dr);
        JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty("net.sf.jasperreports.compiler.", DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, params);
        return jp;
    }

    public static String generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        log.debug((Object)"generating JRXML");
        return JRXmlWriter.writeReport((JRReport)jr, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, OutputStream outputStream) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        JRXmlWriter.writeReport((JRReport)jr, (OutputStream)outputStream, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, String filename) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        DynamicJasperHelper.ensurePath(filename);
        log.debug((Object)("generating JRXML to " + filename));
        JRXmlWriter.writeReport((JRReport)jr, (String)filename, (String)xmlEncoding);
    }

    public static void generateJRXML(JasperReport jr, String xmlEncoding, String filename) throws JRException {
        if (xmlEncoding == null) {
            xmlEncoding = DEFAULT_XML_ENCODING;
        }
        DynamicJasperHelper.ensurePath(filename);
        log.debug((Object)("generating JRXML to " + filename));
        JRXmlWriter.writeReport((JRReport)jr, (String)filename, (String)xmlEncoding);
    }

    private static void ensurePath(String filename) {
        File outputFile = new File(filename);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
    }

    protected static void compileOrLoadSubreports(DynamicReport dr, Map<String, Object> _parameters, String namePrefix) throws JRException {
        log.debug((Object)("Visiting subreports for " + namePrefix));
        int groupnum = 0;
        for (DJGroup group : dr.getColumnsGroups()) {
            JasperReport jp;
            HashMap<String, HashMap<String, JasperReport>> originalParameters;
            String name;
            ++groupnum;
            int subreportNum = 1;
            for (Subreport subreport : group.getHeaderSubreports()) {
                name = namePrefix + "_g" + groupnum + "sr" + subreportNum + "h";
                subreport.setName(name);
                if (subreport.getDynamicReport() != null) {
                    originalParameters = _parameters;
                    if (subreport.getParametersExpression() != null) {
                        _parameters = (HashMap<String, HashMap<String, JasperReport>>)originalParameters.get(subreport.getParametersExpression());
                    }
                    jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters, name);
                    _parameters.put(name, (HashMap<String, JasperReport>)jp);
                    subreport.setReport(jp);
                    log.debug((Object)("Adding Header Subreport " + name + " to parameters map"));
                    _parameters = originalParameters;
                }
                ++subreportNum;
            }
            subreportNum = 1;
            for (Subreport subreport : group.getFooterSubreports()) {
                name = namePrefix + "[g" + groupnum + "sr" + subreportNum + "footer]";
                subreport.setName(name);
                if (subreport.getDynamicReport() != null) {
                    originalParameters = _parameters;
                    if (subreport.getParametersExpression() != null && (_parameters = (Map)originalParameters.get(subreport.getParametersExpression())) == null) {
                        _parameters = new HashMap<String, HashMap<String, JasperReport>>();
                        originalParameters.put(subreport.getParametersExpression(), _parameters);
                    }
                    jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters, name);
                    _parameters.put(name, (HashMap<String, JasperReport>)jp);
                    subreport.setReport(jp);
                    log.debug((Object)("Adding Footer Subreport " + name + " to parameters map"));
                    _parameters = originalParameters;
                }
                ++subreportNum;
            }
        }
        log.debug((Object)("Finished compiling and loading subreports for " + namePrefix));
    }

    public static void registerParams(DynamicJasperDesign jd, Map _parameters) {
        for (Object key : _parameters.keySet()) {
            if (!(key instanceof String)) continue;
            try {
                Object value = _parameters.get(key);
                if (jd.getParametersMap().get(key) != null) {
                    log.warn((Object)("Parameter \"" + key + "\" already registered, skipping this one: " + value));
                    continue;
                }
                JRDesignParameter parameter = new JRDesignParameter();
                if (value == null) continue;
                Class<?> clazz = value.getClass().getComponentType();
                if (clazz == null) {
                    clazz = value.getClass();
                }
                parameter.setValueClass(clazz);
                parameter.setName((String)key);
                jd.addParameter((JRParameter)parameter);
            }
            catch (JRException jRException) {}
        }
    }

    public static JasperReport generateJasperReport(DynamicReport dr, LayoutManager layoutManager, Map generatedParams) throws JRException {
        log.info((Object)"generating JasperReport (DynamicReport dr, LayoutManager layoutManager, Map generatedParams)");
        return DynamicJasperHelper.generateJasperReport(dr, layoutManager, generatedParams, "r");
    }

    public static JasperReport generateJasperReport(DynamicReport dr, LayoutManager layoutManager, Map generatedParams, String nameprefix) throws JRException {
        log.info((Object)("generating JasperReport with prefix: " + nameprefix));
        if (generatedParams == null) {
            log.warn((Object)"null parameters map passed to DynamicJasperHelper, you wont be able to retrieve some generated values during the layout process.");
            generatedParams = new HashMap<String, Object>();
        }
        DynamicJasperHelper.visitSubreports(dr, generatedParams);
        DynamicJasperHelper.compileOrLoadSubreports(dr, generatedParams, nameprefix);
        log.debug((Object)("Continuing with Jasper Design for " + nameprefix));
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        DynamicJasperHelper.registerEntities(jd, dr, layoutManager);
        DynamicJasperHelper.registerParams(jd, generatedParams);
        if (dr.getJasperDesignDecorator() != null) {
            dr.getJasperDesignDecorator().beforeLayout(jd, generatedParams);
        }
        layoutManager.applyLayout(jd, dr);
        if (dr.getJasperDesignDecorator() != null) {
            dr.getJasperDesignDecorator().afterLayout(jd, generatedParams);
        }
        JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty("net.sf.jasperreports.compiler.", DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        generatedParams.putAll(jd.getParametersWithValues());
        log.info((Object)("Done generating JasperReport for design with name: " + jd.getName()));
        return jr;
    }

    protected static void visitSubreports(DynamicReport dr, Map _parameters) {
        for (DJGroup group : dr.getColumnsGroups()) {
            for (Subreport subreport : group.getHeaderSubreports()) {
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.visitSubreport(dr, subreport);
                DynamicJasperHelper.visitSubreports(subreport.getDynamicReport(), _parameters);
            }
            for (Subreport subreport : group.getFooterSubreports()) {
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.visitSubreport(dr, subreport);
                DynamicJasperHelper.visitSubreports(subreport.getDynamicReport(), _parameters);
            }
        }
    }

    protected static void visitSubreport(DynamicReport parentDr, Subreport subreport) {
        DynamicReport childDr = subreport.getDynamicReport();
        if (subreport.isFitToParentPrintableArea()) {
            childDr.getOptions().setPage(parentDr.getOptions().getPage());
            childDr.getOptions().setLeftMargin(parentDr.getOptions().getLeftMargin());
            childDr.getOptions().setRightMargin(parentDr.getOptions().getRightMargin());
        }
    }
}

