/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;

public class WaterMarkRenderer
extends JRAbstractRenderer {
    private boolean m_licenseTrial = false;

    public WaterMarkRenderer(boolean isLicenseTrial) {
        this.m_licenseTrial = isLicenseTrial;
    }

    public byte getType() {
        return RenderableTypeEnum.SVG.getValue();
    }

    public byte getImageType() {
        return ImageTypeEnum.UNKNOWN.getValue();
    }

    public Dimension2D getDimension() throws JRException {
        return new Dimension(515, 700);
    }

    public byte[] getImageData() throws JRException {
        return new byte[0];
    }

    public void render(Graphics2D g2, Rectangle2D rectangle) throws JRException {
        if (this.m_licenseTrial) {
            AffineTransform originalTransform = g2.getTransform();
            g2.setColor(Color.BLUE);
            g2.draw(rectangle);
            g2.translate(rectangle.getX() + 100.0, rectangle.getMaxY());
            g2.rotate(-0.9599310885968813);
            Font font = new Font("Arial", 0, 120);
            Shape shape = font.createGlyphVector(g2.getFontRenderContext(), "Trial License").getOutline();
            g2.setColor(new Color(255, 0, 0, 100));
            g2.setStroke(new BasicStroke(1.0f));
            g2.draw(shape);
            g2.setTransform(originalTransform);
        }
    }

    public static BufferedImage rotateText(String text, Font font, int width, int height, int textAngle, Color textColor) {
        if (text == null) {
            throw new IllegalArgumentException("text must be not-null ");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("text is empty string");
        }
        if (text.trim().length() == 0) {
            throw new IllegalArgumentException("text must contain at least one character that is not space");
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int i = image.getWidth() - 1; i > -1; --i) {
            for (int j = image.getHeight() - 1; j > -1; --j) {
                if (image.getRGB(i, j) != new Color(255, 255, 255).getRGB()) continue;
                image.setRGB(i, j, new Color(0, 0, 0, 0).getRGB());
            }
        }
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        double completeWidth = fm.stringWidth(text);
        double caLinesCountD = completeWidth / (double)width;
        int caLinesCount = caLinesCountD % 1.0 > 0.0 ? (int)caLinesCountD + 1 : (int)caLinesCountD;
        ArrayList<String> lines = new ArrayList<String>(caLinesCount);
        if (caLinesCount == 1) {
            lines.add(text);
        } else {
            int caSepIdx = text.length() / caLinesCount;
            int i = 0;
            while (i < text.length()) {
                int nextCaSep = i + caSepIdx;
                if (text.length() > nextCaSep) {
                    int sepIdx = text.substring(i, nextCaSep + 1).lastIndexOf(32);
                    if (sepIdx == 0) {
                        ++i;
                        continue;
                    }
                    if (sepIdx == -1) {
                        lines.add(text.substring(i, nextCaSep));
                        i += nextCaSep;
                        continue;
                    }
                    lines.add(text.substring(i, i + sepIdx));
                    i += sepIdx + 1;
                    continue;
                }
                lines.add(text.substring(i));
                break;
            }
        }
        g.rotate(Math.PI / 180 * (double)textAngle, width / 2, height / 2);
        int textHeight = fm.getMaxAscent();
        int lineY = height / 2;
        int halfLines = lines.size() / 2;
        double shiftLines = lines.size() % 2 == 0 ? (double)(halfLines - 1) : (double)halfLines - 0.5;
        lineY = (int)((double)lineY - (double)textHeight * (shiftLines += 0.2));
        for (String line : lines) {
            int lineWidth = fm.stringWidth(line);
            int lineX = width / 2 - lineWidth / 2;
            g.setColor(textColor);
            g.drawChars(line.toCharArray(), 0, line.length(), lineX, lineY);
            lineY += textHeight;
        }
        return image;
    }
}

