/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.core.layout.LayoutException;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.DJChartOptions;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DataSetFactory;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.BarCodeColumn;
import ar.com.fdvs.dj.domain.entities.columns.ImageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.util.ExpressionUtils;
import ar.com.fdvs.dj.util.HyperLinkUtil;
import ar.com.fdvs.dj.util.LayoutUtils;
import ar.com.fdvs.dj.util.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLayoutManager
implements LayoutManager {
    static final Log log = LogFactory.getLog((Class)AbstractLayoutManager.class);
    protected static final String EXPRESSION_TRUE_WHEN_ODD = "new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 == 0)";
    protected static final String EXPRESSION_TRUE_WHEN_EVEN = "new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 != 0)";
    JasperDesign design;
    private DynamicReport report;
    private HashMap reportStyles = new HashMap();
    protected List realGroups = new ArrayList();
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$String;

    protected abstract void transformDetailBandTextField(AbstractColumn var1, JRDesignTextField var2);

    public HashMap getReportStyles() {
        return this.reportStyles;
    }

    public void setReportStyles(HashMap reportStyles) {
        this.reportStyles = reportStyles;
    }

    public void applyLayout(JasperDesign design, DynamicReport report) throws LayoutException {
        log.debug((Object)"Applying Layout...");
        try {
            this.setDesign(design);
            this.setReport(report);
            this.ensureDJStyles();
            this.startLayout();
            this.transformDetailBand();
            this.setWhenNoDataBand();
            this.endLayout();
            this.registerRemainingStyles();
        }
        catch (RuntimeException e) {
            throw new LayoutException(e.getMessage(), e);
        }
    }

    protected void setWhenNoDataBand() {
        log.debug((Object)"setting up WHEN NO DATA band");
        String whenNoDataText = this.getReport().getWhenNoDataText();
        Style style = this.getReport().getWhenNoDataStyle();
        if (whenNoDataText == null || "".equals(whenNoDataText)) {
            return;
        }
        JRDesignBand band = new JRDesignBand();
        this.getDesign().setNoData((JRBand)band);
        JRDesignTextField text = new JRDesignTextField();
        JRDesignExpression expression = ExpressionUtils.createStringExpression("\"" + whenNoDataText + "\"");
        text.setExpression((JRExpression)expression);
        if (style == null) {
            style = this.getReport().getOptions().getDefaultDetailStyle();
        }
        if (this.getReport().isWhenNoDataShowTitle()) {
            LayoutUtils.copyBandElements(band, this.getDesign().getPageHeader());
        }
        if (this.getReport().isWhenNoDataShowColumnHeader()) {
            LayoutUtils.copyBandElements(band, this.getDesign().getColumnHeader());
        }
        int offset = LayoutUtils.findVerticalOffset(band);
        text.setY(offset);
        this.applyStyleToElement(style, (JRDesignElement)text);
        text.setWidth(this.getReport().getOptions().getPrintableWidth());
        text.setHeight(50);
        band.addElement((JRDesignElement)text);
        log.debug((Object)"OK setting up WHEN NO DATA band");
    }

    protected void startLayout() {
        this.setColumnsFinalWidth();
        this.realGroups.addAll(this.getDesign().getGroupsList());
    }

    protected void endLayout() {
        this.layoutCharts();
        this.setBandsFinalHeight();
    }

    protected void registerRemainingStyles() {
    }

    protected void ensureDJStyles() {
        Iterator iterator = this.getReport().getStyles().values().iterator();
        while (iterator.hasNext()) {
            Style style = (Style)iterator.next();
            this.addStyleToDesign(style);
        }
        Style defaultDetailStyle = this.getReport().getOptions().getDefaultDetailStyle();
        Style defaultHeaderStyle = this.getReport().getOptions().getDefaultHeaderStyle();
        Iterator iter = this.report.getColumns().iterator();
        while (iter.hasNext()) {
            AbstractColumn column = (AbstractColumn)iter.next();
            if (column.getStyle() == null) {
                column.setStyle(defaultDetailStyle);
            }
            if (column.getHeaderStyle() != null) continue;
            column.setHeaderStyle(defaultHeaderStyle);
        }
    }

    public void addStyleToDesign(Style style) {
        JRDesignStyle jrstyle = style.transform();
        try {
            JRStyle old;
            if (jrstyle.getName() == null) {
                String name = this.createUniqueStyleName();
                jrstyle.setName(name);
                style.setName(name);
                this.getReportStyles().put(name, jrstyle);
                this.design.addStyle((JRStyle)jrstyle);
            }
            if ((old = (JRStyle)this.design.getStylesMap().get(jrstyle.getName())) != null && style.isOverridesExistingStyle()) {
                log.debug((Object)("Overriding style with name \"" + style.getName() + "\""));
                this.design.removeStyle(style.getName());
                this.design.addStyle((JRStyle)jrstyle);
            } else if (old == null) {
                log.debug((Object)("Registering new style with name \"" + style.getName() + "\""));
                this.design.addStyle((JRStyle)jrstyle);
            } else if (style.getName() != null) {
                log.debug((Object)("Using existing style for style with name \"" + style.getName() + "\""));
            }
        }
        catch (JRException e) {
            log.debug((Object)("Duplicated style (it's ok): " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUniqueStyleName() {
        AbstractLayoutManager abstractLayoutManager = this;
        synchronized (abstractLayoutManager) {
            int counter = this.getReportStyles().values().size() + 1;
            String tryName = "dj_style_" + counter;
            while (this.design.getStylesMap().get(tryName) != null) {
                tryName = "dj_style_" + ++counter;
            }
            return tryName;
        }
    }

    protected void transformDetailBand() {
        log.debug((Object)"transforming Detail Band...");
        JRDesignBand detail = (JRDesignBand)this.design.getDetail();
        if (detail == null) {
            detail = new JRDesignBand();
            this.design.setDetail((JRBand)detail);
        }
        detail.setHeight(this.report.getOptions().getDetailHeight().intValue());
        Iterator iter = this.getVisibleColumns().iterator();
        while (iter.hasNext()) {
            JRDesignExpression imageExp;
            JRDesignImage image;
            AbstractColumn column = (AbstractColumn)iter.next();
            if (column instanceof BarCodeColumn) {
                BarCodeColumn barcodeColumn = (BarCodeColumn)column;
                image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                imageExp = new JRDesignExpression();
                String applicationIdentifier = barcodeColumn.getApplicationIdentifier();
                applicationIdentifier = applicationIdentifier != null && !"".equals(applicationIdentifier.trim()) ? "$F{" + applicationIdentifier + "}" : "\"\"";
                imageExp.setText("ar.com.fdvs.dj.core.BarcodeHelper.getBarcodeImage(" + barcodeColumn.getBarcodeType() + ", " + column.getTextForExpression() + ", " + barcodeColumn.isShowText() + ", " + barcodeColumn.isCheckSum() + ", " + applicationIdentifier + ",0,0 )");
                imageExp.setValueClass(class$java$awt$Image == null ? AbstractLayoutManager.class$("java.awt.Image") : class$java$awt$Image);
                image.setExpression((JRExpression)imageExp);
                image.setHeight(this.getReport().getOptions().getDetailHeight().intValue());
                image.setWidth(column.getWidth().intValue());
                image.setX(column.getPosX().intValue());
                image.setScaleImage(barcodeColumn.getScaleMode().getValue());
                image.setOnErrorType((byte)3);
                if (column.getLink() != null) {
                    String name = "column_" + this.getReport().getColumns().indexOf(column);
                    HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), image, name);
                }
                this.applyStyleToElement(column.getStyle(), (JRDesignElement)image);
                detail.addElement((JRDesignElement)image);
                continue;
            }
            if (column instanceof ImageColumn) {
                ImageColumn imageColumn = (ImageColumn)column;
                image = new JRDesignImage(new JRDesignStyle().getDefaultStyleProvider());
                imageExp = new JRDesignExpression();
                imageExp.setText(column.getTextForExpression());
                imageExp.setValueClassName(imageColumn.getColumnProperty().getValueClassName());
                image.setExpression((JRExpression)imageExp);
                image.setHeight(this.getReport().getOptions().getDetailHeight().intValue());
                image.setWidth(column.getWidth().intValue());
                image.setX(column.getPosX().intValue());
                image.setScaleImage(imageColumn.getScaleMode().getValue());
                this.applyStyleToElement(column.getStyle(), (JRDesignElement)image);
                if (column.getLink() != null) {
                    String name = "column_" + this.getReport().getColumns().indexOf(column);
                    HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), image, name);
                }
                detail.addElement((JRDesignElement)image);
                continue;
            }
            if (!this.getReport().getOptions().isShowDetailBand()) continue;
            JRDesignTextField textField = this.generateTextFieldFromColumn(column, this.getReport().getOptions().getDetailHeight(), null);
            if (column.getLink() != null) {
                String name = "column_" + this.getReport().getColumns().indexOf(column);
                HyperLinkUtil.applyHyperLinkToElement((DynamicJasperDesign)this.getDesign(), column.getLink(), textField, name);
            }
            this.transformDetailBandTextField(column, textField);
            if (textField.getExpression() == null) continue;
            detail.addElement((JRDesignElement)textField);
        }
    }

    protected JRDesignExpression getExpressionForConditionalStyle(ConditionalStyle condition, AbstractColumn column) {
        String columExpression = column.getTextForExpression();
        String fieldsMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentFiels()";
        String parametersMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentParams()";
        String variablesMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentVariables()";
        String evalMethodParams = fieldsMap + ", " + variablesMap + ", " + parametersMap + ", " + columExpression;
        String text = "((" + ConditionStyleExpression.class.getName() + ")$P{" + condition.getName() + "})." + "evaluate" + "(" + evalMethodParams + ")";
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Boolean.class);
        expression.setText(text);
        return expression;
    }

    protected void generateHeaderBand(JRDesignBand band) {
        log.debug((Object)"Generating header band...");
        band.setHeight(this.report.getOptions().getHeaderHeight().intValue());
        Iterator iter = this.getVisibleColumns().iterator();
        while (iter.hasNext()) {
            AbstractColumn col = (AbstractColumn)iter.next();
            if (col.getTitle() == null) continue;
            JRDesignExpression expression = new JRDesignExpression();
            JRDesignTextField textField = new JRDesignTextField();
            expression.setText("\"" + col.getTitle() + "\"");
            expression.setValueClass(class$java$lang$String == null ? AbstractLayoutManager.class$("java.lang.String") : class$java$lang$String);
            textField.setKey("header_" + col.getTitle());
            textField.setExpression((JRExpression)expression);
            textField.setX(col.getPosX().intValue());
            textField.setY(col.getPosY().intValue());
            textField.setHeight(band.getHeight());
            textField.setWidth(col.getWidth().intValue());
            textField.setPrintWhenDetailOverflows(true);
            textField.setBlankWhenNull(true);
            Style headerStyle = col.getHeaderStyle();
            if (headerStyle == null) {
                headerStyle = this.report.getOptions().getDefaultHeaderStyle();
            }
            this.applyStyleToElement(headerStyle, (JRDesignElement)textField);
            band.addElement((JRDesignElement)textField);
        }
    }

    public void applyStyleToElement(Style style, JRDesignElement designElemen) {
        JRDesignTextElement textField;
        if (style == null) {
            JRDesignStyle style_ = new JRDesignStyle();
            style_.setName(this.createUniqueStyleName());
            designElemen.setStyle((JRStyle)style_);
            try {
                this.getDesign().addStyle((JRStyle)style_);
            }
            catch (JRException e) {
                // empty catch block
            }
            return;
        }
        boolean existsInDesign = style.getName() != null && this.design.getStylesMap().get(style.getName()) != null;
        JRDesignStyle jrstyle = null;
        if (existsInDesign && !style.isOverridesExistingStyle()) {
            jrstyle = (JRDesignStyle)this.design.getStylesMap().get(style.getName());
        } else {
            this.addStyleToDesign(style);
            jrstyle = style.transform();
        }
        designElemen.setStyle((JRStyle)jrstyle);
        if (designElemen instanceof JRDesignTextElement) {
            textField = (JRDesignTextElement)designElemen;
            if (style.getStreching() != null) {
                textField.setStretchType(style.getStreching().getValue());
            }
            textField.setPositionType((byte)1);
        }
        if (designElemen instanceof JRDesignTextField) {
            textField = (JRDesignTextField)designElemen;
            textField.setStretchWithOverflow(style.isStretchWithOverflow());
            if (!textField.isBlankWhenNull() && style.isBlankWhenNull()) {
                textField.setBlankWhenNull(true);
            }
        }
    }

    protected void setColumnsFinalWidth() {
        log.debug((Object)"Setting columns final width...");
        float factor = 1.0f;
        int printableArea = this.report.getOptions().getColumnWidth();
        List visibleColums = this.getVisibleColumns();
        log.debug((Object)("printableArea = " + printableArea));
        if (this.report.getOptions().isUseFullPageWidth()) {
            int columnsWidth = 0;
            int notRezisableWidth = 0;
            Iterator iterator = visibleColums.iterator();
            while (iterator.hasNext()) {
                AbstractColumn col = (AbstractColumn)iterator.next();
                columnsWidth += col.getWidth().intValue();
                if (!col.getFixedWidth().booleanValue()) continue;
                notRezisableWidth += col.getWidth().intValue();
            }
            log.debug((Object)("columnsWidth = " + columnsWidth));
            log.debug((Object)("notRezisableWidth = " + notRezisableWidth));
            factor = (float)(printableArea - notRezisableWidth) / (float)(columnsWidth - notRezisableWidth);
            log.debug((Object)("factor = " + factor));
            int acu = 0;
            int colFinalWidth = 0;
            Collection resizableColumns = CollectionUtils.select((Collection)visibleColums, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return ((AbstractColumn)arg0).getFixedWidth() == false;
                }
            });
            Iterator iter = resizableColumns.iterator();
            while (iter.hasNext()) {
                AbstractColumn col = (AbstractColumn)iter.next();
                if (!iter.hasNext()) {
                    col.setWidth(new Integer(printableArea - notRezisableWidth - acu));
                    continue;
                }
                colFinalWidth = new Float((float)col.getWidth().intValue() * factor).intValue();
                acu += colFinalWidth;
                col.setWidth(new Integer(colFinalWidth));
            }
        }
        int posx = 0;
        Iterator iterator = visibleColums.iterator();
        while (iterator.hasNext()) {
            AbstractColumn col = (AbstractColumn)iterator.next();
            col.setPosX(new Integer(posx));
            posx += col.getWidth().intValue();
        }
    }

    protected List getVisibleColumns() {
        ArrayList visibleColums = new ArrayList(this.report.getColumns());
        return visibleColums;
    }

    protected void setBandsFinalHeight() {
        log.debug((Object)"Setting bands final height...");
        this.setBandFinalHeight((JRDesignBand)this.design.getPageHeader());
        this.setBandFinalHeight((JRDesignBand)this.design.getPageFooter());
        this.setBandFinalHeight((JRDesignBand)this.design.getColumnHeader());
        this.setBandFinalHeight((JRDesignBand)this.design.getColumnFooter());
        this.setBandFinalHeight((JRDesignBand)this.design.getSummary());
        this.setBandFinalHeight((JRDesignBand)this.design.getBackground());
        this.setBandFinalHeight((JRDesignBand)this.design.getDetail());
        this.setBandFinalHeight((JRDesignBand)this.design.getLastPageFooter());
        this.setBandFinalHeight((JRDesignBand)this.design.getTitle());
        this.setBandFinalHeight((JRDesignBand)this.design.getPageFooter());
        this.setBandFinalHeight((JRDesignBand)this.design.getNoData());
        Iterator iter = this.design.getGroupsList().iterator();
        while (iter.hasNext()) {
            JRGroup jrgroup = (JRGroup)iter.next();
            DJGroup djGroup = (DJGroup)this.getReferencesMap().get(jrgroup.getName());
            if (djGroup != null) {
                this.setBandFinalHeight((JRDesignBand)jrgroup.getGroupHeader(), djGroup.getHeaderHeight(), djGroup.isFitHeaderHeightToContent());
                this.setBandFinalHeight((JRDesignBand)jrgroup.getGroupFooter(), djGroup.getFooterHeight(), djGroup.isFitFooterHeightToContent());
                continue;
            }
            this.setBandFinalHeight((JRDesignBand)jrgroup.getGroupHeader());
            this.setBandFinalHeight((JRDesignBand)jrgroup.getGroupFooter());
        }
    }

    private void setBandFinalHeight(JRDesignBand band, int currHeigth, boolean fitToContent) {
        int finalHeight;
        if (band != null && ((finalHeight = LayoutUtils.findVerticalOffset(band)) >= currHeigth || fitToContent)) {
            band.setHeight(finalHeight);
        }
    }

    protected void setBandFinalHeight(JRDesignBand band) {
        if (band != null) {
            int finalHeight = LayoutUtils.findVerticalOffset(band);
            band.setHeight(finalHeight);
        }
    }

    protected JRDesignTextField generateTextFieldFromColumn(AbstractColumn col, int height, DJGroup group) {
        JRDesignTextField textField = new JRDesignTextField();
        JRDesignExpression exp = new JRDesignExpression();
        if (col.getPattern() != null && "".equals(col.getPattern().trim())) {
            textField.setPattern(col.getPattern());
        }
        if (col.getTruncateSuffix() != null) {
            textField.getPropertiesMap().setProperty("net.sf.jasperreports.text.truncate.suffix", col.getTruncateSuffix());
        }
        exp.setText(col.getTextForExpression());
        exp.setValueClassName(col.getValueClassNameForExpression());
        textField.setExpression((JRExpression)exp);
        textField.setWidth(col.getWidth().intValue());
        textField.setX(col.getPosX().intValue());
        textField.setY(col.getPosY().intValue());
        textField.setHeight(height);
        textField.setBlankWhenNull(col.getBlankWhenNull());
        textField.setPattern(col.getPattern());
        textField.setPrintRepeatedValues(col.getPrintRepeatedValues().booleanValue());
        textField.setPrintWhenDetailOverflows(true);
        Style columnStyle = col.getStyle();
        if (columnStyle == null) {
            columnStyle = this.report.getOptions().getDefaultDetailStyle();
        }
        this.applyStyleToElement(columnStyle, (JRDesignElement)textField);
        JRDesignStyle jrstyle = (JRDesignStyle)textField.getStyle();
        if (group != null) {
            int index = this.getReport().getColumnsGroups().indexOf(group);
            JRDesignGroup previousGroup = this.getJRGroupFromDJGroup(group);
            textField.setPrintWhenGroupChanges((JRGroup)previousGroup);
            JRDesignStyle groupStyle = (JRDesignStyle)jrstyle.clone();
            groupStyle.setName(groupStyle.getFontName() + "_for_group_" + index);
            textField.setStyle((JRStyle)groupStyle);
            try {
                this.design.addStyle((JRStyle)groupStyle);
            }
            catch (JRException e) {}
        } else {
            JRDesignStyle alternateStyle = (JRDesignStyle)jrstyle.clone();
            alternateStyle.setName(alternateStyle.getFontName() + "_for_column_" + col.getName());
            alternateStyle.getConditionalStyleList().clear();
            textField.setStyle((JRStyle)alternateStyle);
            try {
                this.design.addStyle((JRStyle)alternateStyle);
            }
            catch (JRException e) {
                // empty catch block
            }
            this.setUpConditionStyles(alternateStyle, col);
        }
        return textField;
    }

    private void setUpConditionStyles(JRDesignStyle jrstyle, AbstractColumn column) {
        if (this.getReport().getOptions().isPrintBackgroundOnOddRows() && Utils.isEmpty(column.getConditionalStyles())) {
            JRDesignExpression expression = new JRDesignExpression();
            expression.setValueClass(Boolean.class);
            expression.setText(EXPRESSION_TRUE_WHEN_ODD);
            Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
            condStyle.setMode((byte)1);
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
            return;
        }
        if (Utils.isEmpty(column.getConditionalStyles())) {
            return;
        }
        Iterator iterator = column.getConditionalStyles().iterator();
        while (iterator.hasNext()) {
            ConditionalStyle condition = (ConditionalStyle)iterator.next();
            if (this.getReport().getOptions().isPrintBackgroundOnOddRows() && Transparency.TRANSPARENT == condition.getStyle().getTransparency()) {
                JRDesignExpression expressionForConditionalStyle = this.getExpressionForConditionalStyle(condition, column);
                String expStr = JRExpressionUtil.getExpressionText((JRExpression)expressionForConditionalStyle);
                JRDesignExpression expressionOdd = new JRDesignExpression();
                expressionOdd.setValueClass(class$java$lang$Boolean == null ? AbstractLayoutManager.class$("java.lang.Boolean") : class$java$lang$Boolean);
                expressionOdd.setText("new java.lang.Boolean(new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 == 0).booleanValue() && ((java.lang.Boolean)" + expStr + ").booleanValue() )");
                Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
                JRDesignConditionalStyle condStyleOdd = this.makeConditionalStyle(condition.getStyle());
                condStyleOdd.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
                condStyleOdd.setMode((byte)1);
                condStyleOdd.setConditionExpression((JRExpression)expressionOdd);
                jrstyle.addConditionalStyle((JRConditionalStyle)condStyleOdd);
                JRDesignExpression expressionEven = new JRDesignExpression();
                expressionEven.setValueClass(class$java$lang$Boolean == null ? AbstractLayoutManager.class$("java.lang.Boolean") : class$java$lang$Boolean);
                expressionEven.setText("new java.lang.Boolean(new java.lang.Boolean(((Number)$V{REPORT_COUNT}).doubleValue() % 2 != 0).booleanValue() && ((java.lang.Boolean)" + expStr + ").booleanValue() )");
                JRDesignConditionalStyle condStyleEven = this.makeConditionalStyle(condition.getStyle());
                condStyleEven.setConditionExpression((JRExpression)expressionEven);
                jrstyle.addConditionalStyle((JRConditionalStyle)condStyleEven);
                continue;
            }
            JRDesignExpression expression = this.getExpressionForConditionalStyle(condition, column);
            JRDesignConditionalStyle condStyle = this.makeConditionalStyle(condition.getStyle());
            condStyle.setConditionExpression((JRExpression)expression);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
        if (this.getReport().getOptions().isPrintBackgroundOnOddRows()) {
            JRDesignExpression expressionOdd = new JRDesignExpression();
            expressionOdd.setValueClass(Boolean.class);
            expressionOdd.setText(EXPRESSION_TRUE_WHEN_ODD);
            Style oddRowBackgroundStyle = this.getReport().getOptions().getOddRowBackgroundStyle();
            JRDesignConditionalStyle condStyleOdd = new JRDesignConditionalStyle();
            condStyleOdd.setBackcolor(oddRowBackgroundStyle.getBackgroundColor());
            condStyleOdd.setMode((byte)1);
            condStyleOdd.setConditionExpression((JRExpression)expressionOdd);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyleOdd);
            JRDesignExpression expressionEven = new JRDesignExpression();
            expressionEven.setValueClass(Boolean.class);
            expressionEven.setText(EXPRESSION_TRUE_WHEN_EVEN);
            JRDesignConditionalStyle condStyleEven = new JRDesignConditionalStyle();
            condStyleEven.setBackcolor(jrstyle.getBackcolor());
            condStyleEven.setMode(jrstyle.getMode());
            condStyleEven.setConditionExpression((JRExpression)expressionEven);
            jrstyle.addConditionalStyle((JRConditionalStyle)condStyleEven);
        }
    }

    protected JRDesignConditionalStyle makeConditionalStyle(Style style) {
        JRDesignConditionalStyle condStyle = style.transformAsConditinalStyle();
        return condStyle;
    }

    protected void layoutCharts() {
        MultiHashMap mmap = new MultiHashMap();
        Iterator iter = this.getReport().getCharts().iterator();
        while (iter.hasNext()) {
            DJChart djChart = (DJChart)iter.next();
            mmap.put((Object)djChart.getColumnsGroup(), (Object)djChart);
        }
        Iterator iterator = mmap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Collection charts = (Collection)mmap.get(key);
            ArrayList l = new ArrayList(charts);
            for (int i = l.size(); i > 0; --i) {
                DJChart djChart = (DJChart)l.get(i - 1);
                JRDesignChart chart = this.createChart(djChart);
                JRDesignBand band = this.createGroupForChartAndGetBand(djChart);
                band.addElement((JRDesignElement)chart);
            }
        }
    }

    protected JRDesignBand createGroupForChartAndGetBand(DJChart djChart) {
        JRDesignGroup jrGroup = this.getJRGroupFromDJGroup(djChart.getColumnsGroup());
        JRDesignGroup parentGroup = this.getParent(jrGroup);
        JRDesignGroup jrGroupChart = null;
        try {
            jrGroupChart = (JRDesignGroup)BeanUtils.cloneBean((Object)parentGroup);
            jrGroupChart.setGroupFooter((JRBand)new JRDesignBand());
            jrGroupChart.setGroupHeader((JRBand)new JRDesignBand());
            jrGroupChart.setName(jrGroupChart.getName() + "_Chart" + this.getReport().getCharts().indexOf(djChart));
        }
        catch (Exception e) {
            throw new DJException("Problem creating band for chart: " + e.getMessage(), e);
        }
        if (jrGroup.equals(parentGroup)) {
            jrGroupChart.setExpression((JRExpression)ExpressionUtils.createStringExpression("\"dummy_for_chart\""));
            this.getDesign().getGroupsList().add(this.getDesign().getGroupsList().indexOf(jrGroup), jrGroupChart);
        } else {
            int index = this.getDesign().getGroupsList().indexOf(parentGroup);
            this.getDesign().getGroupsList().add(index, jrGroupChart);
        }
        JRDesignBand band = null;
        switch (djChart.getOptions().getPosition()) {
            case 2: {
                band = (JRDesignBand)jrGroupChart.getGroupHeader();
                break;
            }
            case 1: {
                band = (JRDesignBand)jrGroupChart.getGroupFooter();
            }
        }
        return band;
    }

    protected JRDesignChart createChart(DJChart djChart) {
        JRDesignGroup jrGroupChart = this.getJRGroupFromDJGroup(djChart.getColumnsGroup());
        JRDesignChart chart = new JRDesignChart(new JRDesignStyle().getDefaultStyleProvider(), djChart.getType());
        JRDesignGroup parentGroup = this.getParent(jrGroupChart);
        List chartVariables = this.registerChartVariable(djChart);
        JRDesignChartDataset chartDataset = DataSetFactory.getDataset(djChart, jrGroupChart, parentGroup, chartVariables);
        chart.setDataset((JRChartDataset)chartDataset);
        this.interpeterOptions(djChart, chart);
        chart.setEvaluationTime((byte)5);
        chart.setEvaluationGroup((JRGroup)jrGroupChart);
        return chart;
    }

    protected void interpeterOptions(DJChart djChart, JRDesignChart chart) {
        DJChartOptions options = djChart.getOptions();
        if (options.isCentered()) {
            chart.setWidth(this.getReport().getOptions().getPrintableWidth());
        } else {
            chart.setWidth(options.getWidth());
        }
        chart.setHeight(options.getHeight());
        chart.setX(options.getX());
        chart.setPadding(10);
        chart.setY(options.getY());
        chart.setShowLegend(options.isShowLegend());
        chart.setBackcolor(options.getBackColor());
        chart.setBorder(options.getBorder());
        if (options.getColors() != null) {
            int i = 1;
            Iterator iter = options.getColors().iterator();
            while (iter.hasNext()) {
                Color color = (Color)iter.next();
                chart.getPlot().getSeriesColors().add(new JRBaseChartPlot.JRBaseSeriesColor(i, color));
                ++i;
            }
        }
        if (djChart.getType() == 3) {
            ((JRDesignBarPlot)chart.getPlot()).setShowTickLabels(options.isShowLabels());
        }
    }

    protected List registerChartVariable(DJChart chart) {
        JRDesignGroup group = this.getJRGroupFromDJGroup(chart.getColumnsGroup());
        ArrayList<JRDesignVariable> vars = new ArrayList<JRDesignVariable>();
        int serieNum = 0;
        Iterator iterator = chart.getColumns().iterator();
        while (iterator.hasNext()) {
            AbstractColumn col = (AbstractColumn)iterator.next();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(col.getValueClassNameForExpression());
            }
            catch (ClassNotFoundException e) {
                throw new DJException("Exeption creating chart variable: " + e.getMessage(), e);
            }
            JRDesignExpression expression = new JRDesignExpression();
            expression.setText("$F{" + ((PropertyColumn)col).getColumnProperty().getProperty() + "}");
            expression.setValueClass(clazz);
            JRDesignVariable var = new JRDesignVariable();
            var.setValueClass(clazz);
            var.setExpression((JRExpression)expression);
            var.setCalculation(chart.getOperation());
            var.setResetGroup((JRGroup)group);
            var.setResetType((byte)4);
            int chartIndex = this.getReport().getCharts().indexOf(chart);
            var.setName("CHART_[" + chartIndex + "_s" + serieNum + "+]_" + group.getName() + "_" + col.getTitle() + "_" + chart.getOperation());
            try {
                this.getDesign().addVariable(var);
                vars.add(var);
            }
            catch (JRException e) {
                throw new LayoutException(e.getMessage());
            }
            ++serieNum;
        }
        return vars;
    }

    protected JRDesignGroup getParent(JRDesignGroup group) {
        int index = this.realGroups.indexOf(group);
        JRDesignGroup parentGroup = index > 0 ? (JRDesignGroup)this.realGroups.get(index - 1) : group;
        return parentGroup;
    }

    protected JRDesignGroup getJRGroupFromDJGroup(DJGroup group) {
        int index = this.getReport().getColumnsGroups().indexOf(group);
        return (JRDesignGroup)this.realGroups.get(index);
    }

    protected DJGroup getDJGroup(AbstractColumn col) {
        Iterator it = this.getReport().getColumnsGroups().iterator();
        while (it.hasNext()) {
            DJGroup group = (DJGroup)it.next();
            if (!group.getColumnToGroupBy().equals(col)) continue;
            return group;
        }
        return null;
    }

    protected boolean existsGroupWithColumnNames() {
        Iterator it = this.getReport().getColumnsGroups().iterator();
        while (it.hasNext()) {
            DJGroup group = (DJGroup)it.next();
            if (!group.getLayout().isShowColumnName()) continue;
            return true;
        }
        return false;
    }

    protected JasperDesign getDesign() {
        return this.design;
    }

    protected void setDesign(JasperDesign design) {
        this.design = design;
    }

    protected DynamicReport getReport() {
        return this.report;
    }

    protected void setReport(DynamicReport report) {
        this.report = report;
    }
}

