/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities.columns;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionColumn
extends SimpleColumn {
    private static final Log log = LogFactory.getLog((Class)ExpressionColumn.class);
    private CustomExpression expression;
    private CustomExpression expressionForCalculation;
    private Collection columns;
    private Collection variables;
    private String calculatedExpressionText = null;

    public Collection getVariables() {
        return this.variables;
    }

    public void setVariables(Collection variables) {
        this.variables = variables;
    }

    public Collection getColumns() {
        return this.columns;
    }

    public void setColumns(Collection columns) {
        this.columns = columns;
    }

    public CustomExpression getExpression() {
        return this.expression;
    }

    public void setExpression(CustomExpression expression) {
        this.expression = expression;
    }

    public String getValueClassNameForExpression() {
        if (this.expression == null) {
            return Object.class.getName();
        }
        return this.expression.getClassName();
    }

    public String getTextForExpression() {
        if (this.calculatedExpressionText != null) {
            return this.calculatedExpressionText;
        }
        String fieldsMap = DJDefaultScriptlet.class.getName() + ".getCurrentFiels()";
        String parametersMap = DJDefaultScriptlet.class.getName() + ".getCurrentParams()";
        String variablesMap = DJDefaultScriptlet.class.getName() + ".getCurrentVariables()";
        String stringExpression = "(((" + CustomExpression.class.getName() + ")$P{" + this.getColumnProperty().getProperty() + "})." + "evaluate" + "( " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        log.debug((Object)("Expression for CustomExpression = " + stringExpression));
        this.calculatedExpressionText = stringExpression;
        return stringExpression;
    }

    public String getTextForExpressionForCalculartion() {
        String fieldsMap = DJDefaultScriptlet.class.getName() + ".getCurrentFiels()";
        String parametersMap = DJDefaultScriptlet.class.getName() + ".getCurrentParams()";
        String variablesMap = DJDefaultScriptlet.class.getName() + ".getCurrentVariables()";
        String stringExpression = "(((" + CustomExpression.class.getName() + ")$P{" + this.getColumnProperty().getProperty() + "_calc})." + "evaluate" + "( " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " ))";
        log.debug((Object)("Calculation Expression for CustomExpression = " + stringExpression));
        return stringExpression;
    }

    public CustomExpression getExpressionForCalculation() {
        return this.expressionForCalculation;
    }

    public void setExpressionForCalculation(CustomExpression expressionForCalculation) {
        this.expressionForCalculation = expressionForCalculation;
    }

    public String getVariableClassName(DJCalculation op) {
        if (op == DJCalculation.COUNT || op == DJCalculation.DISTINCT_COUNT) {
            return Long.class.getName();
        }
        if (this.expressionForCalculation != null) {
            return this.expressionForCalculation.getClassName();
        }
        if (this.expression != null) {
            return this.expression.getClassName();
        }
        return super.getVariableClassName(op);
    }

    public String getInitialExpression(DJCalculation op) {
        if (op == DJCalculation.COUNT || op == DJCalculation.DISTINCT_COUNT) {
            return "new java.lang.Long(\"0\")";
        }
        if (op == DJCalculation.SUM) {
            return "new " + this.getVariableClassName(op) + "(\"0\")";
        }
        return null;
    }
}

