/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.entities.Subreport;
import java.sql.ResultSet;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class ExpressionUtils {
    private static final String REPORT_PARAMETERS_MAP = "$P{REPORT_PARAMETERS_MAP}";

    public static JRDesignExpression getParameterExpression(Subreport sr) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(Map.class.getName());
        if (sr.isUseParentReportParameters()) {
            exp.setText(REPORT_PARAMETERS_MAP);
            return exp;
        }
        if (sr.getParametersExpression() == null) {
            return null;
        }
        if (sr.getParametersMapOrigin() == 0) {
            exp.setText("$P{REPORT_PARAMETERS_MAP}.get( \"" + sr.getParametersExpression() + "\" )");
            return exp;
        }
        if (sr.getParametersMapOrigin() == 1) {
            exp.setText("$F{" + sr.getParametersExpression() + "}");
            return exp;
        }
        return null;
    }

    public static JRDesignExpression getDataSourceExpression(DJDataSource ds) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(JRDataSource.class);
        String dsType = ExpressionUtils.getDataSourceTypeStr(ds.getDataSourceType());
        String expText = null;
        if (ds.getDataSourceOrigin() == 1) {
            expText = dsType + "$F{" + ds.getDataSourceExpression() + "})";
        } else if (ds.getDataSourceOrigin() == 0) {
            expText = dsType + REPORT_PARAMETERS_MAP + ".get( \"" + ds.getDataSourceExpression() + "\" ) )";
        }
        exp.setText(expText);
        return exp;
    }

    protected static String getDataSourceTypeStr(int datasourceType) {
        String dsType = "(";
        if (0 == datasourceType) {
            dsType = "new " + JRBeanCollectionDataSource.class.getName() + "((java.util.Collection)";
        } else if (1 == datasourceType) {
            dsType = "new " + JRBeanArrayDataSource.class.getName() + "((Object[])";
        } else if (3 == datasourceType) {
            dsType = "new " + JRResultSetDataSource.class.getName() + "((" + ResultSet.class.getName() + ")";
        } else if (10 == datasourceType) {
            dsType = "((" + JRDataSource.class.getName() + ")";
        }
        return dsType;
    }

    public static JRDesignExpression createStringExpression(String text) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createExpression(String text, Class clazz) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(clazz);
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createExpression(String text, String className) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(className);
        exp.setText(text);
        return exp;
    }
}

