/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.entities.Subreport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubReportBuilder {
    private static final Log logger = LogFactory.getLog((Class)SubReportBuilder.class);
    private Subreport subreport = new Subreport();

    public Subreport build() throws DJBuilderException {
        if (this.subreport.getPath() == null && this.subreport.getDynamicReport() == null && this.subreport.getReport() == null) {
            throw new DJBuilderException("No subreport origin defined (path, dynamicReport, jasperReport)");
        }
        if (this.subreport.getPath() != null) {
            JasperReport jr = null;
            File file = new File(this.subreport.getPath());
            if (file.exists()) {
                logger.debug((Object)"Loading subreport from file path");
                try {
                    jr = (JasperReport)JRLoader.loadObject((File)file);
                }
                catch (JRException e) {
                    throw new DJBuilderException("Could not load subreport.", e);
                }
            }
            logger.debug((Object)"Loading subreport from classpath");
            URL url = DynamicJasperHelper.class.getClassLoader().getResource(this.subreport.getPath());
            try {
                jr = (JasperReport)JRLoader.loadObject((InputStream)url.openStream());
            }
            catch (IOException e) {
                throw new DJBuilderException("Could not open subreport as an input stream", e);
            }
            catch (JRException e) {
                throw new DJBuilderException("Could not load subreport.", e);
            }
            this.subreport.setReport(jr);
        }
        return this.subreport;
    }

    public SubReportBuilder setDataSource(int origin, int type, String expression) {
        DJDataSource ds = new DJDataSource(expression, origin, type);
        this.subreport.setDatasource(ds);
        return this;
    }

    public SubReportBuilder setDataSource(int origin, String expression) {
        return this.setDataSource(origin, 10, expression);
    }

    public SubReportBuilder setDataSource(String expression) {
        return this.setDataSource(0, 10, expression);
    }

    public SubReportBuilder setReport(JasperReport jasperReport) {
        this.subreport.setReport(jasperReport);
        return this;
    }

    public SubReportBuilder setDynamicReport(DynamicReport dynamicReport, LayoutManager layoutManager) {
        this.subreport.setDynamicReport(dynamicReport);
        this.subreport.setLayoutManager(layoutManager);
        return this;
    }

    public SubReportBuilder setPathToReport(String path) {
        this.subreport.setPath(path);
        return this;
    }
}

