/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListLayoutManager
extends AbstractLayoutManager {
    private static final Log log = LogFactory.getLog((Class)ListLayoutManager.class);

    protected void startLayout() {
        this.getReport().getOptions().setColumnsPerPage(new Integer(1));
        this.getReport().getOptions().setColumnSpace(new Integer(0));
        this.getDesign().setColumnCount(1);
        this.getDesign().setColumnWidth(this.getReport().getOptions().getColumnWidth());
        super.startLayout();
        if (this.getReport().getOptions().isPrintColumnNames()) {
            this.generateHeaderBand();
        }
        this.getDesign().setIgnorePagination(this.getReport().getOptions().isIgnorePagination());
    }

    protected void transformDetailBandTextField(AbstractColumn column, JRDesignTextField textField) {
        log.debug((Object)"transforming detail band text field...");
        textField.setPrintRepeatedValues(true);
        try {
            if (Number.class.isAssignableFrom(Class.forName(textField.getExpression().getValueClassName()))) {
                textField.setPattern(null);
            }
        }
        catch (ClassNotFoundException e) {
            throw new LayoutException(e.getMessage());
        }
    }

    private void generateHeaderBand() {
        log.debug((Object)"generating header band...");
        JRDesignBand header = (JRDesignBand)this.getDesign().getColumnHeader();
        if (header == null) {
            header = new JRDesignBand();
            this.getDesign().setColumnHeader((JRBand)header);
        }
        this.generateHeaderBand(header);
    }
}

