/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral.network;

import android.content.Context;
import android.support.annotation.Nullable;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerResponse;
import io.branch.referral.network.BranchRemoteInterfaceUrlConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BranchRemoteInterface {
    public static final String RETRY_NUMBER = "retryNumber";

    public abstract BranchResponse doRestfulGet(String var1) throws BranchRemoteException;

    public abstract BranchResponse doRestfulPost(String var1, JSONObject var2) throws BranchRemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerResponse make_restful_get(String url, JSONObject params, String tag, String branchKey) {
        String modifiedUrl = url;
        JSONObject jSONObject = params = params != null ? params : new JSONObject();
        if (!this.addCommonParams(params, branchKey)) {
            return new ServerResponse(tag, -114);
        }
        modifiedUrl = modifiedUrl + this.convertJSONtoString(params);
        long reqStartTime = System.currentTimeMillis();
        PrefHelper.Debug("BranchSDK", "getting " + modifiedUrl);
        try {
            BranchResponse response = this.doRestfulGet(modifiedUrl);
            ServerResponse serverResponse = this.processEntityForJSON(response.responseData, response.responseCode, tag);
            return serverResponse;
        }
        catch (BranchRemoteException branchError) {
            if (branchError.branchErrorCode == -111) {
                ServerResponse serverResponse = new ServerResponse(tag, -111);
                return serverResponse;
            }
            ServerResponse serverResponse = new ServerResponse(tag, -113);
            return serverResponse;
        }
        finally {
            if (Branch.getInstance() != null) {
                int brttVal = (int)(System.currentTimeMillis() - reqStartTime);
                Branch.getInstance().addExtraInstrumentationData(tag + "-" + Defines.Jsonkey.Branch_Round_Trip_Time.getKey(), String.valueOf(brttVal));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerResponse make_restful_post(JSONObject body, String url, String tag, String branchKey) {
        long reqStartTime = System.currentTimeMillis();
        JSONObject jSONObject = body = body != null ? body : new JSONObject();
        if (!this.addCommonParams(body, branchKey)) {
            return new ServerResponse(tag, -114);
        }
        PrefHelper.Debug("BranchSDK", "posting to " + url);
        PrefHelper.Debug("BranchSDK", "Post value = " + body.toString());
        try {
            BranchResponse response = this.doRestfulPost(url, body);
            ServerResponse serverResponse = this.processEntityForJSON(response.responseData, response.responseCode, tag);
            return serverResponse;
        }
        catch (BranchRemoteException branchError) {
            if (branchError.branchErrorCode == -111) {
                ServerResponse serverResponse = new ServerResponse(tag, -111);
                return serverResponse;
            }
            ServerResponse serverResponse = new ServerResponse(tag, -113);
            return serverResponse;
        }
        finally {
            if (Branch.getInstance() != null) {
                int brttVal = (int)(System.currentTimeMillis() - reqStartTime);
                Branch.getInstance().addExtraInstrumentationData(tag + "-" + Defines.Jsonkey.Branch_Round_Trip_Time.getKey(), String.valueOf(brttVal));
            }
        }
    }

    public static final BranchRemoteInterface getDefaultBranchRemoteInterface(Context context) {
        BranchRemoteInterfaceUrlConnection branchRemoteInterface = null;
        boolean isOkHttpAvailable = false;
        if (!isOkHttpAvailable) {
            branchRemoteInterface = new BranchRemoteInterfaceUrlConnection(context);
        }
        return branchRemoteInterface;
    }

    private ServerResponse processEntityForJSON(String responseString, int statusCode, String tag) {
        ServerResponse result = new ServerResponse(tag, statusCode);
        PrefHelper.Debug("BranchSDK", "returned " + responseString);
        if (responseString != null) {
            try {
                JSONObject jsonObj = new JSONObject(responseString);
                result.setPost(jsonObj);
            }
            catch (JSONException ex) {
                try {
                    JSONArray jsonArray = new JSONArray(responseString);
                    result.setPost(jsonArray);
                }
                catch (JSONException ex2) {
                    PrefHelper.Debug(this.getClass().getSimpleName(), "JSON exception: " + ex2.getMessage());
                }
            }
        }
        return result;
    }

    private boolean addCommonParams(JSONObject post, String branch_key) {
        try {
            post.put("sdk", (Object)"android2.9.1");
            if (!branch_key.equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.BranchKey.getKey(), (Object)branch_key);
                return true;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return false;
    }

    private String convertJSONtoString(JSONObject json) {
        JSONArray names;
        StringBuilder result = new StringBuilder();
        if (json != null && (names = json.names()) != null) {
            boolean first = true;
            int size = names.length();
            for (int i = 0; i < size; ++i) {
                try {
                    String key = names.getString(i);
                    if (first) {
                        result.append("?");
                        first = false;
                    } else {
                        result.append("&");
                    }
                    String value = json.getString(key);
                    result.append(key).append("=").append(value);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return result.toString();
    }

    public static class BranchRemoteException
    extends Exception {
        private int branchErrorCode = -113;

        public BranchRemoteException(int errorCode) {
            this.branchErrorCode = errorCode;
        }
    }

    public static class BranchResponse {
        private final String responseData;
        private final int responseCode;

        public BranchResponse(@Nullable String responseData, int responseCode) {
            this.responseData = responseData;
            this.responseCode = responseCode;
        }
    }
}

