/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import io.branch.referral.AnimatedDialog;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchShortLinkBuilder;
import io.branch.referral.SharingHelper;
import java.util.ArrayList;
import java.util.List;

class ShareLinkManager {
    AnimatedDialog shareDlg_;
    Branch.BranchLinkShareListener callback_;
    Branch.IChannelProperties channelPropertiesCallback_;
    private List<ResolveInfo> appList_;
    private Intent shareLinkIntent_;
    private final int BG_COLOR_ENABLED = Color.argb((int)60, (int)17, (int)4, (int)56);
    private final int BG_COLOR_DISABLED = Color.argb((int)20, (int)17, (int)4, (int)56);
    Context context_;
    private static int viewItemMinHeight_ = 100;
    private boolean isShareInProgress_ = false;
    private int shareDialogThemeID_ = -1;
    private Branch.ShareLinkBuilder builder_;
    final int padding = 5;
    final int leftMargin = 100;
    private List<String> includeInShareSheet = new ArrayList<String>();
    private List<String> excludeFromShareSheet = new ArrayList<String>();

    ShareLinkManager() {
    }

    public Dialog shareLink(Branch.ShareLinkBuilder builder) {
        this.builder_ = builder;
        this.context_ = builder.getActivity();
        this.callback_ = builder.getCallback();
        this.channelPropertiesCallback_ = builder.getChannelPropertiesCallback();
        this.shareLinkIntent_ = new Intent("android.intent.action.SEND");
        this.shareLinkIntent_.setType("text/plain");
        this.shareDialogThemeID_ = builder.getStyleResourceID();
        this.includeInShareSheet = builder.getIncludedInShareSheet();
        this.excludeFromShareSheet = builder.getExcludedFromShareSheet();
        try {
            this.createShareDialog(builder.getPreferredOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.callback_ != null) {
                this.callback_.onLinkShareResponse(null, null, new BranchError("Trouble sharing link", -110));
            }
            Log.i((String)"BranchSDK", (String)"Unable create share options. Couldn't find applications on device to share the link.");
        }
        return this.shareDlg_;
    }

    public void cancelShareLinkDialog(boolean animateClose) {
        if (this.shareDlg_ != null && this.shareDlg_.isShowing()) {
            if (animateClose) {
                this.shareDlg_.cancel();
            } else {
                this.shareDlg_.dismiss();
            }
        }
    }

    private void createShareDialog(List<SharingHelper.SHARE_WITH> preferredOptions) {
        PackageManager packageManager = this.context_.getPackageManager();
        ArrayList<ResolveInfo> preferredApps = new ArrayList<ResolveInfo>();
        List matchingApps = packageManager.queryIntentActivities(this.shareLinkIntent_, 65536);
        List<ResolveInfo> cleanedMatchingApps = new ArrayList();
        final ArrayList<ResolveInfo> cleanedMatchingAppsFinal = new ArrayList<ResolveInfo>();
        ArrayList<SharingHelper.SHARE_WITH> packagesFilterList = new ArrayList<SharingHelper.SHARE_WITH>(preferredOptions);
        for (ResolveInfo resolveInfo : matchingApps) {
            Object foundMatching = null;
            String packageName = resolveInfo.activityInfo.packageName;
            for (SharingHelper.SHARE_WITH PackageFilter : packagesFilterList) {
                if (resolveInfo.activityInfo == null || !packageName.toLowerCase().contains(PackageFilter.toString().toLowerCase())) continue;
                foundMatching = PackageFilter;
                break;
            }
            if (foundMatching == null) continue;
            preferredApps.add(resolveInfo);
            preferredOptions.remove(foundMatching);
        }
        matchingApps.removeAll(preferredApps);
        matchingApps.addAll(0, preferredApps);
        if (this.includeInShareSheet.size() > 0) {
            for (ResolveInfo r : matchingApps) {
                if (!this.includeInShareSheet.contains(r.activityInfo.packageName)) continue;
                cleanedMatchingApps.add(r);
            }
        } else {
            cleanedMatchingApps = matchingApps;
        }
        for (ResolveInfo r : cleanedMatchingApps) {
            if (this.excludeFromShareSheet.contains(r.activityInfo.packageName)) continue;
            cleanedMatchingAppsFinal.add(r);
        }
        for (ResolveInfo r : matchingApps) {
            for (SharingHelper.SHARE_WITH shareWith : packagesFilterList) {
                if (!shareWith.toString().equalsIgnoreCase(r.activityInfo.packageName)) continue;
                cleanedMatchingAppsFinal.add(r);
            }
        }
        cleanedMatchingAppsFinal.add(new CopyLinkItem());
        matchingApps.add(new CopyLinkItem());
        preferredApps.add(new CopyLinkItem());
        if (preferredApps.size() > 1) {
            if (matchingApps.size() > preferredApps.size()) {
                preferredApps.add(new MoreShareItem());
            }
            this.appList_ = preferredApps;
        } else {
            this.appList_ = cleanedMatchingAppsFinal;
        }
        final ChooserArrayAdapter adapter = new ChooserArrayAdapter();
        ListView shareOptionListView = this.shareDialogThemeID_ > 1 && Build.VERSION.SDK_INT >= 21 ? new ListView(this.context_, null, 0, this.shareDialogThemeID_) : new ListView(this.context_);
        shareOptionListView.setHorizontalFadingEdgeEnabled(false);
        shareOptionListView.setBackgroundColor(-1);
        if (this.builder_.getSharingTitleView() != null) {
            shareOptionListView.addHeaderView(this.builder_.getSharingTitleView(), null, false);
        } else if (!TextUtils.isEmpty((CharSequence)this.builder_.getSharingTitle())) {
            TextView textView = new TextView(this.context_);
            textView.setText((CharSequence)this.builder_.getSharingTitle());
            textView.setBackgroundColor(this.BG_COLOR_DISABLED);
            textView.setTextColor(this.BG_COLOR_DISABLED);
            textView.setTextAppearance(this.context_, 16973892);
            textView.setTextColor(this.context_.getResources().getColor(0x1060000));
            textView.setPadding(100, 5, 5, 5);
            shareOptionListView.addHeaderView((View)textView, null, false);
        }
        shareOptionListView.setAdapter((ListAdapter)adapter);
        if (this.builder_.getDividerHeight() >= 0) {
            shareOptionListView.setDividerHeight(this.builder_.getDividerHeight());
        } else if (this.builder_.getIsFullWidthStyle()) {
            shareOptionListView.setDividerHeight(0);
        }
        shareOptionListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int pos, long l) {
                if (view.getTag() instanceof MoreShareItem) {
                    ShareLinkManager.this.appList_ = cleanedMatchingAppsFinal;
                    adapter.notifyDataSetChanged();
                } else {
                    if (ShareLinkManager.this.callback_ != null) {
                        String selectedChannelName = "";
                        if (view.getTag() != null && ShareLinkManager.this.context_ != null && ((ResolveInfo)view.getTag()).loadLabel(ShareLinkManager.this.context_.getPackageManager()) != null) {
                            selectedChannelName = ((ResolveInfo)view.getTag()).loadLabel(ShareLinkManager.this.context_.getPackageManager()).toString();
                        }
                        ShareLinkManager.this.callback_.onChannelSelected(selectedChannelName);
                    }
                    adapter.selectedPos = pos;
                    adapter.notifyDataSetChanged();
                    ShareLinkManager.this.invokeSharingClient((ResolveInfo)view.getTag());
                    if (ShareLinkManager.this.shareDlg_ != null) {
                        ShareLinkManager.this.shareDlg_.cancel();
                    }
                }
            }
        });
        this.shareDlg_ = new AnimatedDialog(this.context_, this.builder_.getIsFullWidthStyle());
        this.shareDlg_.setContentView((View)shareOptionListView);
        this.shareDlg_.show();
        if (this.callback_ != null) {
            this.callback_.onShareLinkDialogLaunched();
        }
        this.shareDlg_.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (ShareLinkManager.this.callback_ != null) {
                    ShareLinkManager.this.callback_.onShareLinkDialogDismissed();
                    ShareLinkManager.this.callback_ = null;
                }
                if (!ShareLinkManager.this.isShareInProgress_) {
                    ShareLinkManager.this.context_ = null;
                    ShareLinkManager.this.builder_ = null;
                }
                ShareLinkManager.this.shareDlg_ = null;
            }
        });
    }

    private void invokeSharingClient(final ResolveInfo selectedResolveInfo) {
        this.isShareInProgress_ = true;
        final String channelName = selectedResolveInfo.loadLabel(this.context_.getPackageManager()).toString();
        BranchShortLinkBuilder shortLinkBuilder = this.builder_.getShortLinkBuilder();
        shortLinkBuilder.setChannel(channelName);
        shortLinkBuilder.generateShortUrlInternal(new Branch.BranchLinkCreateListener(){

            @Override
            public void onLinkCreate(String url, BranchError error) {
                if (error == null) {
                    ShareLinkManager.this.shareWithClient(selectedResolveInfo, url, channelName);
                } else {
                    String defaultUrl = ShareLinkManager.this.builder_.getDefaultURL();
                    if (defaultUrl != null && defaultUrl.trim().length() > 0) {
                        ShareLinkManager.this.shareWithClient(selectedResolveInfo, defaultUrl, channelName);
                    } else {
                        if (ShareLinkManager.this.callback_ != null) {
                            ShareLinkManager.this.callback_.onLinkShareResponse(url, channelName, error);
                        } else {
                            Log.i((String)"BranchSDK", (String)("Unable to share link " + error.getMessage()));
                        }
                        if (error.getErrorCode() == -113) {
                            ShareLinkManager.this.shareWithClient(selectedResolveInfo, url, channelName);
                        } else {
                            ShareLinkManager.this.cancelShareLinkDialog(false);
                            ShareLinkManager.this.isShareInProgress_ = false;
                        }
                    }
                }
            }
        }, true);
    }

    private void shareWithClient(ResolveInfo selectedResolveInfo, String url, String channelName) {
        if (this.callback_ != null) {
            this.callback_.onLinkShareResponse(url, channelName, null);
        } else {
            Log.i((String)"BranchSDK", (String)("Shared link with " + channelName));
        }
        if (selectedResolveInfo instanceof CopyLinkItem) {
            this.addLinkToClipBoard(url, this.builder_.getShareMsg());
        } else {
            this.shareLinkIntent_.setPackage(selectedResolveInfo.activityInfo.packageName);
            String shareSub = this.builder_.getShareSub();
            String shareMsg = this.builder_.getShareMsg();
            if (this.channelPropertiesCallback_ != null) {
                String customShareSub = this.channelPropertiesCallback_.getSharingTitleForChannel(channelName);
                String customShareMsg = this.channelPropertiesCallback_.getSharingMessageForChannel(channelName);
                if (!TextUtils.isEmpty((CharSequence)customShareSub)) {
                    shareSub = customShareSub;
                }
                if (!TextUtils.isEmpty((CharSequence)customShareMsg)) {
                    shareMsg = customShareMsg;
                }
            }
            if (shareSub != null && shareSub.trim().length() > 0) {
                this.shareLinkIntent_.putExtra("android.intent.extra.SUBJECT", shareSub);
            }
            this.shareLinkIntent_.putExtra("android.intent.extra.TEXT", shareMsg + "\n" + url);
            this.context_.startActivity(this.shareLinkIntent_);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void addLinkToClipBoard(String url, String label) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 11) {
            android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.context_.getSystemService("clipboard");
            clipboard.setText((CharSequence)url);
        } else {
            ClipboardManager clipboard = (ClipboardManager)this.context_.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)label, (CharSequence)url);
            clipboard.setPrimaryClip(clip);
        }
        Toast.makeText((Context)this.context_, (CharSequence)this.builder_.getUrlCopiedMessage(), (int)0).show();
    }

    private class CopyLinkItem
    extends ResolveInfo {
        private CopyLinkItem() {
        }

        public CharSequence loadLabel(PackageManager pm) {
            return ShareLinkManager.this.builder_.getCopyURlText();
        }

        public Drawable loadIcon(PackageManager pm) {
            return ShareLinkManager.this.builder_.getCopyUrlIcon();
        }
    }

    private class MoreShareItem
    extends ResolveInfo {
        private MoreShareItem() {
        }

        public CharSequence loadLabel(PackageManager pm) {
            return ShareLinkManager.this.builder_.getMoreOptionText();
        }

        public Drawable loadIcon(PackageManager pm) {
            return ShareLinkManager.this.builder_.getMoreOptionIcon();
        }
    }

    private class ShareItemView
    extends TextView {
        Context context_;

        public ShareItemView(Context context) {
            super(context);
            this.context_ = context;
            this.setPadding(100, 5, 5, 5);
            this.setGravity(8388627);
            this.setMinWidth(this.context_.getResources().getDisplayMetrics().widthPixels);
        }

        public void setLabel(String appName, Drawable appIcon, boolean isEnabled) {
            this.setText("\t" + appName);
            this.setTag(appName);
            if (appIcon == null) {
                this.setTextAppearance(this.context_, 16973890);
                this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            } else {
                this.setTextAppearance(this.context_, 16973892);
                this.setCompoundDrawablesWithIntrinsicBounds(appIcon, null, null, null);
                viewItemMinHeight_ = Math.max(viewItemMinHeight_, appIcon.getIntrinsicHeight() + 5);
            }
            this.setMinHeight(viewItemMinHeight_);
            this.setTextColor(this.context_.getResources().getColor(17170444));
            if (isEnabled) {
                this.setBackgroundColor(ShareLinkManager.this.BG_COLOR_ENABLED);
            } else {
                this.setBackgroundColor(ShareLinkManager.this.BG_COLOR_DISABLED);
            }
        }
    }

    private class ChooserArrayAdapter
    extends BaseAdapter {
        public int selectedPos = -1;

        private ChooserArrayAdapter() {
        }

        public int getCount() {
            return ShareLinkManager.this.appList_.size();
        }

        public Object getItem(int position) {
            return ShareLinkManager.this.appList_.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ShareItemView itemView = convertView == null ? new ShareItemView(ShareLinkManager.this.context_) : (ShareItemView)convertView;
            ResolveInfo resolveInfo = (ResolveInfo)ShareLinkManager.this.appList_.get(position);
            boolean setSelected = position == this.selectedPos;
            itemView.setLabel(resolveInfo.loadLabel(ShareLinkManager.this.context_.getPackageManager()).toString(), resolveInfo.loadIcon(ShareLinkManager.this.context_.getPackageManager()), setSelected);
            itemView.setTag(resolveInfo);
            itemView.setClickable(false);
            return itemView;
        }

        public boolean isEnabled(int position) {
            return this.selectedPos < 0;
        }
    }
}

