/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.os.Build;
import io.branch.indexing.BranchUniversalObject;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRegisterView
extends ServerRequest {
    BranchUniversalObject.RegisterViewStatusListener callback_;

    public ServerRequestRegisterView(Context context, BranchUniversalObject branchUniversalObject, SystemObserver sysObserver, BranchUniversalObject.RegisterViewStatusListener callback) {
        super(context, Defines.RequestPath.RegisterView.getPath());
        this.callback_ = callback;
        try {
            JSONObject registerViewPost = this.createContentViewJson(branchUniversalObject, sysObserver);
            this.setPost(registerViewPost);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        if (this.callback_ != null) {
            this.callback_.onRegisterViewFinished(true, null);
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            this.callback_.onRegisterViewFinished(false, new BranchError("Unable to register content view. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onRegisterViewFinished(false, new BranchError("Unable to register content view", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    private JSONObject createContentViewJson(BranchUniversalObject universalObject, SystemObserver sysObserver) throws JSONException {
        long expiryTime;
        String contentType;
        String imageUrl;
        String desc;
        String title;
        String canonicalUrl;
        String canonicalId;
        String appVersion;
        JSONObject contentObject = new JSONObject();
        String os_Info = "Android " + Build.VERSION.SDK_INT;
        String sessionID = this.prefHelper_.getSessionID();
        contentObject.put(Defines.Jsonkey.SessionID.getKey(), (Object)sessionID);
        contentObject.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
        String uniqueId = DeviceInfo.getInstance() != null ? DeviceInfo.getInstance().getHardwareID() : sysObserver.getUniqueID(this.prefHelper_.getExternDebug());
        if (!uniqueId.equals("bnc_no_value") && sysObserver.hasRealHardwareId()) {
            contentObject.put(Defines.Jsonkey.HardwareID.getKey(), (Object)uniqueId);
        }
        if (!(appVersion = sysObserver.getAppVersion()).equals("bnc_no_value")) {
            contentObject.put(Defines.Jsonkey.AppVersion.getKey(), (Object)appVersion);
        }
        JSONObject paramsObj = new JSONObject();
        paramsObj.put(Defines.Jsonkey.ContentKeyWords.getKey(), (Object)universalObject.getKeywordsJsonArray());
        paramsObj.put(Defines.Jsonkey.PublicallyIndexable.getKey(), universalObject.isPublicallyIndexable());
        if (universalObject.getPrice() > 0.0) {
            paramsObj.put("$amount", universalObject.getPrice());
            paramsObj.put("$currency", (Object)universalObject.getCurrencyType());
        }
        if ((canonicalId = universalObject.getCanonicalIdentifier()) != null && canonicalId.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.CanonicalIdentifier.getKey(), (Object)canonicalId);
        }
        if ((canonicalUrl = universalObject.getCanonicalUrl()) != null && canonicalUrl.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.CanonicalUrl.getKey(), (Object)canonicalUrl);
        }
        if ((title = universalObject.getTitle()) != null && title.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.ContentTitle.getKey(), (Object)universalObject.getTitle());
        }
        if ((desc = universalObject.getDescription()) != null && desc.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.ContentDesc.getKey(), (Object)desc);
        }
        if ((imageUrl = universalObject.getImageUrl()) != null && imageUrl.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.ContentImgUrl.getKey(), (Object)imageUrl);
        }
        if ((contentType = universalObject.getType()) != null && contentType.trim().length() > 0) {
            paramsObj.put(Defines.Jsonkey.ContentType.getKey(), (Object)contentType);
        }
        if ((expiryTime = universalObject.getExpirationTime()) > 0L) {
            paramsObj.put(Defines.Jsonkey.ContentExpiryTime.getKey(), universalObject.getExpirationTime());
        }
        contentObject.put(Defines.Jsonkey.Params.getKey(), (Object)paramsObj);
        HashMap<String, String> metaData = universalObject.getMetadata();
        Set<String> extraKeys = metaData.keySet();
        JSONObject metaDataObject = new JSONObject();
        for (String key : extraKeys) {
            metaDataObject.put(key, (Object)metaData.get(key));
        }
        contentObject.put(Defines.Jsonkey.Metadata.getKey(), (Object)metaDataObject);
        return contentObject;
    }

    @Override
    public boolean isGAdsParamsRequired() {
        return true;
    }
}

