/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRegisterInstall
extends ServerRequestInitSession {
    Branch.BranchReferralInitListener callback_;
    final SystemObserver systemObserver_;

    public ServerRequestRegisterInstall(Context context, Branch.BranchReferralInitListener callback, SystemObserver sysObserver, String installID) {
        super(context, Defines.RequestPath.RegisterInstall.getPath());
        this.systemObserver_ = sysObserver;
        this.callback_ = callback;
        JSONObject installPost = new JSONObject();
        try {
            String uriScheme;
            if (!installID.equals("bnc_no_value")) {
                installPost.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)installID);
            }
            if (!sysObserver.getAppVersion().equals("bnc_no_value")) {
                installPost.put(Defines.Jsonkey.AppVersion.getKey(), (Object)sysObserver.getAppVersion());
            }
            if (this.prefHelper_.getExternDebug() && !(uriScheme = sysObserver.getURIScheme()).equals("bnc_no_value")) {
                installPost.put(Defines.Jsonkey.URIScheme.getKey(), (Object)uriScheme);
            }
            installPost.put(Defines.Jsonkey.FaceBookAppLinkChecked.getKey(), this.prefHelper_.getIsAppLinkTriggeredInit());
            installPost.put(Defines.Jsonkey.IsReferrable.getKey(), this.prefHelper_.getIsReferrable());
            installPost.put(Defines.Jsonkey.Update.getKey(), sysObserver.getUpdateState());
            installPost.put(Defines.Jsonkey.Debug.getKey(), this.prefHelper_.getExternDebug());
            this.setPost(installPost);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestRegisterInstall(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
        this.systemObserver_ = new SystemObserver(context);
    }

    @Override
    public boolean hasCallBack() {
        return this.callback_ != null;
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        super.onRequestSucceeded(resp, branch);
        try {
            JSONObject dataObj;
            this.prefHelper_.setUserURL(resp.getObject().getString(Defines.Jsonkey.Link.getKey()));
            if (resp.getObject().has(Defines.Jsonkey.Data.getKey()) && (dataObj = new JSONObject(resp.getObject().getString(Defines.Jsonkey.Data.getKey()))).has(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && dataObj.getBoolean(Defines.Jsonkey.Clicked_Branch_Link.getKey()) && this.prefHelper_.getInstallParams().equals("bnc_no_value") && this.prefHelper_.getIsReferrable() == 1) {
                String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                this.prefHelper_.setInstallParams(params);
            }
            if (resp.getObject().has(Defines.Jsonkey.LinkClickID.getKey())) {
                this.prefHelper_.setLinkClickID(resp.getObject().getString(Defines.Jsonkey.LinkClickID.getKey()));
            } else {
                this.prefHelper_.setLinkClickID("bnc_no_value");
            }
            if (resp.getObject().has(Defines.Jsonkey.Data.getKey())) {
                String params = resp.getObject().getString(Defines.Jsonkey.Data.getKey());
                this.prefHelper_.setSessionParams(params);
            } else {
                this.prefHelper_.setSessionParams("bnc_no_value");
            }
            if (this.callback_ != null) {
                this.callback_.onInitFinished(branch.getLatestReferringParams(), null);
            }
            this.prefHelper_.setAppVersion(this.systemObserver_.getAppVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.onInitSessionCompleted(resp, branch);
    }

    public void setInitFinishedCallback(Branch.BranchReferralInitListener callback) {
        if (callback != null) {
            this.callback_ = callback;
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            JSONObject obj = new JSONObject();
            try {
                obj.put("error_message", (Object)"Trouble reaching server. Please try again in a few minutes");
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            this.callback_.onInitFinished(obj, new BranchError("Trouble initializing Branch. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onInitFinished(null, new BranchError("Trouble initializing Branch.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    @Override
    public String getRequestActionName() {
        return "install";
    }
}

