/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestRedeemRewards
extends ServerRequest {
    Branch.BranchReferralStateChangedListener callback_;
    int actualNumOfCreditsToRedeem_ = 0;

    public ServerRequestRedeemRewards(Context context, String bucketName, int numOfCreditsToRedeem, Branch.BranchReferralStateChangedListener callback) {
        super(context, Defines.RequestPath.RedeemRewards.getPath());
        this.callback_ = callback;
        int availableCredits = this.prefHelper_.getCreditCount(bucketName);
        this.actualNumOfCreditsToRedeem_ = numOfCreditsToRedeem;
        if (numOfCreditsToRedeem > availableCredits) {
            this.actualNumOfCreditsToRedeem_ = availableCredits;
            Log.i((String)"BranchSDK", (String)"Branch Warning: You're trying to redeem more credits than are available. Have you updated loaded rewards");
        }
        if (this.actualNumOfCreditsToRedeem_ > 0) {
            JSONObject post = new JSONObject();
            try {
                post.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
                post.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
                post.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
                if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                    post.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
                }
                post.put(Defines.Jsonkey.Bucket.getKey(), (Object)bucketName);
                post.put(Defines.Jsonkey.Amount.getKey(), this.actualNumOfCreditsToRedeem_);
                this.setPost(post);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                this.constructError_ = true;
            }
        }
    }

    public ServerRequestRedeemRewards(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onStateChanged(false, new BranchError("Trouble redeeming rewards.", -102));
            }
            return true;
        }
        if (this.actualNumOfCreditsToRedeem_ <= 0) {
            if (this.callback_ != null) {
                this.callback_.onStateChanged(false, new BranchError("Trouble redeeming rewards.", -107));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        boolean isRedemptionSucceeded = false;
        JSONObject post = this.getPost();
        if (post != null && post.has(Defines.Jsonkey.Bucket.getKey()) && post.has(Defines.Jsonkey.Amount.getKey())) {
            try {
                int redeemedCredits = post.getInt(Defines.Jsonkey.Amount.getKey());
                String creditBucket = post.getString(Defines.Jsonkey.Bucket.getKey());
                isRedemptionSucceeded = redeemedCredits > 0;
                int updatedCreditCount = this.prefHelper_.getCreditCount(creditBucket) - redeemedCredits;
                this.prefHelper_.setCreditCount(creditBucket, updatedCreditCount);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (this.callback_ != null) {
            BranchError branchError = isRedemptionSucceeded ? null : new BranchError("Trouble redeeming rewards.", -107);
            this.callback_.onStateChanged(isRedemptionSucceeded, branchError);
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            this.callback_.onStateChanged(false, new BranchError("Trouble redeeming rewards. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }
}

