/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.app.Activity;
import android.content.Context;
import io.branch.indexing.ContentDiscoverer;
import io.branch.indexing.ContentDiscoveryManifest;
import io.branch.referral.Branch;
import io.branch.referral.BranchViewHandler;
import io.branch.referral.Defines;
import io.branch.referral.ExtendedAnswerProvider;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

abstract class ServerRequestInitSession
extends ServerRequest {
    static final String ACTION_OPEN = "open";
    static final String ACTION_INSTALL = "install";
    private final Context context_;
    private final ContentDiscoveryManifest contentDiscoveryManifest_;

    ServerRequestInitSession(Context context, String requestPath) {
        super(context, requestPath);
        this.context_ = context;
        this.contentDiscoveryManifest_ = ContentDiscoveryManifest.getInstance(this.context_);
    }

    ServerRequestInitSession(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
        this.context_ = context;
        this.contentDiscoveryManifest_ = ContentDiscoveryManifest.getInstance(this.context_);
    }

    @Override
    protected void setPost(JSONObject post) {
        super.setPost(post);
        this.updateEnvironment(this.context_, post);
    }

    public abstract boolean hasCallBack();

    @Override
    public boolean isGAdsParamsRequired() {
        return true;
    }

    public abstract String getRequestActionName();

    static boolean isInitSessionAction(String actionName) {
        boolean isInitSessionAction = false;
        if (actionName != null) {
            isInitSessionAction = actionName.equalsIgnoreCase(ACTION_OPEN) || actionName.equalsIgnoreCase(ACTION_INSTALL);
        }
        return isInitSessionAction;
    }

    boolean handleBranchViewIfAvailable(ServerResponse resp) {
        boolean isBranchViewShowing = false;
        if (resp != null && resp.getObject() != null && resp.getObject().has(Defines.Jsonkey.BranchViewData.getKey())) {
            try {
                JSONObject branchViewJsonObj = resp.getObject().getJSONObject(Defines.Jsonkey.BranchViewData.getKey());
                String actionName = this.getRequestActionName();
                if (Branch.getInstance().currentActivityReference_ != null && Branch.getInstance().currentActivityReference_.get() != null) {
                    Activity currentActivity = (Activity)Branch.getInstance().currentActivityReference_.get();
                    boolean isActivityEnabledForBranchView = true;
                    if (currentActivity instanceof Branch.IBranchViewControl) {
                        boolean bl = isActivityEnabledForBranchView = !((Branch.IBranchViewControl)currentActivity).skipBranchViewsOnThisActivity();
                    }
                    isBranchViewShowing = isActivityEnabledForBranchView ? BranchViewHandler.getInstance().showBranchView(branchViewJsonObj, actionName, (Context)currentActivity, Branch.getInstance()) : BranchViewHandler.getInstance().markInstallOrOpenBranchViewPending(branchViewJsonObj, actionName);
                } else {
                    isBranchViewShowing = BranchViewHandler.getInstance().markInstallOrOpenBranchViewPending(branchViewJsonObj, actionName);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return isBranchViewShowing;
    }

    @Override
    public void onRequestSucceeded(ServerResponse response, Branch branch) {
        try {
            this.prefHelper_.setLinkClickIdentifier("bnc_no_value");
            this.prefHelper_.setGoogleSearchInstallIdentifier("bnc_no_value");
            this.prefHelper_.setExternalIntentUri("bnc_no_value");
            this.prefHelper_.setExternalIntentExtra("bnc_no_value");
            this.prefHelper_.setAppLink("bnc_no_value");
            this.prefHelper_.setPushIdentifier("bnc_no_value");
            this.prefHelper_.setIsAppLinkTriggeredInit(false);
            this.prefHelper_.setInstallReferrerParams("bnc_no_value");
            this.prefHelper_.setIsFullAppConversion(false);
            if (response.getObject() != null && response.getObject().has(Defines.Jsonkey.Data.getKey())) {
                String eventName = this instanceof ServerRequestRegisterInstall ? "Branch Install" : "Branch Open";
                JSONObject linkDataJsonObj = new JSONObject(response.getObject().getString(Defines.Jsonkey.Data.getKey()));
                new ExtendedAnswerProvider().provideData(eventName, linkDataJsonObj, this.prefHelper_.getIdentityID());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    void onInitSessionCompleted(ServerResponse response, Branch branch) {
        if (this.contentDiscoveryManifest_ != null) {
            this.contentDiscoveryManifest_.onBranchInitialised(response.getObject());
            if (branch.currentActivityReference_ != null) {
                try {
                    ContentDiscoverer.getInstance().onSessionStarted((Activity)branch.currentActivityReference_.get(), branch.sessionReferredLink_);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void updateLinkReferrerParams() {
        if (!this.prefHelper_.getLinkClickIdentifier().equals("bnc_no_value")) {
            try {
                this.getPost().put(Defines.Jsonkey.LinkIdentifier.getKey(), (Object)this.prefHelper_.getLinkClickIdentifier());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (!this.prefHelper_.getGoogleSearchInstallIdentifier().equals("bnc_no_value")) {
            try {
                this.getPost().put(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey(), (Object)this.prefHelper_.getGoogleSearchInstallIdentifier());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.prefHelper_.isFullAppConversion()) {
            try {
                this.getPost().put(Defines.Jsonkey.AndroidAppLinkURL.getKey(), (Object)this.prefHelper_.getAppLink());
                this.getPost().put(Defines.Jsonkey.IsFullAppConv.getKey(), true);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPreExecute() {
        JSONObject post = this.getPost();
        try {
            if (!this.prefHelper_.getLinkClickIdentifier().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.LinkIdentifier.getKey(), (Object)this.prefHelper_.getLinkClickIdentifier());
            }
            if (!this.prefHelper_.getGoogleSearchInstallIdentifier().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.GoogleSearchInstallReferrer.getKey(), (Object)this.prefHelper_.getGoogleSearchInstallIdentifier());
            }
            if (!this.prefHelper_.getAppLink().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.AndroidAppLinkURL.getKey(), (Object)this.prefHelper_.getAppLink());
            }
            if (!this.prefHelper_.getPushIdentifier().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.AndroidPushIdentifier.getKey(), (Object)this.prefHelper_.getPushIdentifier());
            }
            if (!this.prefHelper_.getExternalIntentUri().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.External_Intent_URI.getKey(), (Object)this.prefHelper_.getExternalIntentUri());
            }
            if (!this.prefHelper_.getExternalIntentExtra().equals("bnc_no_value")) {
                post.put(Defines.Jsonkey.External_Intent_Extra.getKey(), (Object)this.prefHelper_.getExternalIntentExtra());
            }
            if (this.contentDiscoveryManifest_ != null) {
                JSONObject cdObj = new JSONObject();
                cdObj.put("mv", (Object)this.contentDiscoveryManifest_.getManifestVersion());
                cdObj.put("pn", (Object)this.context_.getPackageName());
                post.put("cd", (Object)cdObj);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

