/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.Defines;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestGetRewardHistory
extends ServerRequest {
    Branch.BranchListResponseListener callback_;

    public ServerRequestGetRewardHistory(Context context, String bucket, String afterId, int length, Branch.CreditHistoryOrder order, Branch.BranchListResponseListener callback) {
        super(context, Defines.RequestPath.GetCreditHistory.getPath());
        this.callback_ = callback;
        JSONObject getCreditHistoryPost = new JSONObject();
        try {
            getCreditHistoryPost.put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
            getCreditHistoryPost.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            getCreditHistoryPost.put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                getCreditHistoryPost.put(Defines.Jsonkey.LinkClickID.getKey(), (Object)this.prefHelper_.getLinkClickID());
            }
            getCreditHistoryPost.put(Defines.Jsonkey.Length.getKey(), length);
            getCreditHistoryPost.put(Defines.Jsonkey.Direction.getKey(), order.ordinal());
            if (bucket != null) {
                getCreditHistoryPost.put(Defines.Jsonkey.Bucket.getKey(), (Object)bucket);
            }
            if (afterId != null) {
                getCreditHistoryPost.put(Defines.Jsonkey.BeginAfterID.getKey(), (Object)afterId);
            }
            this.setPost(getCreditHistoryPost);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestGetRewardHistory(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        if (this.callback_ != null) {
            this.callback_.onReceivingResponse(resp.getArray(), null);
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            this.callback_.onReceivingResponse(null, new BranchError("Trouble retrieving user credit history. " + causeMsg, statusCode));
        }
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onReceivingResponse(null, new BranchError("Trouble retrieving user credit history.", -102));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }
}

